/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.common;

import android.content.Context;
import com.kakao.common.RequestConfiguration;
import com.kakao.util.exception.KakaoException;
import com.kakao.util.helper.SystemInfo;
import com.kakao.util.helper.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public interface IConfiguration {
    public String getKeyHash();

    public String getKAHeader();

    public String getPackageName();

    public String getAppVer();

    public JSONObject getExtrasJson();

    @Deprecated
    public String getExtras();

    public static class Factory {
        static IConfiguration createConfiguration(Context context) throws KakaoException {
            SystemInfo.initialize((Context)context);
            String keyHash = Utility.getKeyHash((Context)context);
            String kaHeader = SystemInfo.getKAHeader();
            String appVer = String.valueOf(Utility.getAppVersion((Context)context));
            String packageName = context.getPackageName();
            JSONObject extras = new JSONObject();
            try {
                extras.put("appPkg", (Object)context.getPackageName());
                extras.put("KA", (Object)kaHeader);
                extras.put("keyHash", (Object)keyHash);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("JSON parsing error. Malformed parameters were provided. Detailed error message: " + e.toString());
            }
            return new RequestConfiguration(keyHash, kaHeader, appVer, packageName, extras);
        }
    }
}

