/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.common;

import android.content.Context;
import com.kakao.common.DefaultPhaseInfo;
import com.kakao.common.IConfiguration;
import com.kakao.common.PhaseInfo;

public class KakaoContextService {
    private PhaseInfo phaseInfo;
    private IConfiguration configuration;
    private static KakaoContextService instance;

    public IConfiguration getAppConfiguration() {
        return this.configuration;
    }

    public void setPhaseInfo(PhaseInfo phaseInfo) {
        if (phaseInfo != null) {
            this.phaseInfo = phaseInfo;
        }
    }

    public PhaseInfo phaseInfo() {
        return this.phaseInfo;
    }

    public synchronized void initialize(Context context) {
        if (this.configuration == null) {
            this.configuration = IConfiguration.Factory.createConfiguration(context);
        }
        if (this.phaseInfo == null) {
            this.phaseInfo = new DefaultPhaseInfo(context);
        }
    }

    public synchronized void initialize(Context context, PhaseInfo phaseInfo) {
        if (this.configuration == null) {
            this.configuration = IConfiguration.Factory.createConfiguration(context);
        }
        this.phaseInfo = phaseInfo;
    }

    public KakaoContextService(IConfiguration configuration, PhaseInfo phaseInfo) {
        this.configuration = configuration;
        this.phaseInfo = phaseInfo;
    }

    private KakaoContextService() {
    }

    public static synchronized KakaoContextService getInstance() {
        if (instance == null) {
            instance = new KakaoContextService();
        }
        return instance;
    }
}

