/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.common;

import com.kakao.common.IConfiguration;
import com.kakao.util.exception.KakaoException;
import org.json.JSONObject;

public class RequestConfiguration
implements IConfiguration {
    private String keyHash;
    private String kaHeader;
    private String appVer;
    private String packageName;
    private JSONObject extras;

    public RequestConfiguration(String keyHash, String kaHeader, String appVer, String packageName, JSONObject extras) throws KakaoException {
        if (keyHash == null || keyHash.length() == 0) {
            throw new KakaoException(KakaoException.ErrorType.MISS_CONFIGURATION, "Android key hash is null.");
        }
        this.keyHash = keyHash;
        this.kaHeader = kaHeader;
        this.appVer = appVer;
        this.packageName = packageName;
        this.extras = extras;
    }

    @Override
    public String getKeyHash() {
        return this.keyHash;
    }

    @Override
    public String getKAHeader() {
        return this.kaHeader;
    }

    @Override
    public String getAppVer() {
        return this.appVer;
    }

    @Override
    public String getExtras() {
        if (this.extras == null) {
            return null;
        }
        return this.extras.toString();
    }

    @Override
    public JSONObject getExtrasJson() {
        return this.extras;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }
}

