/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import com.kakao.message.template.ButtonObject;
import com.kakao.message.template.ContentObject;
import com.kakao.message.template.SocialObject;
import com.kakao.message.template.TemplateParams;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeedTemplate
implements TemplateParams {
    private final ContentObject contentObject;
    private final SocialObject socialObject;
    private final List<ButtonObject> buttons;

    public SocialObject getSocial() {
        return this.socialObject;
    }

    public List<ButtonObject> getButtons() {
        return this.buttons;
    }

    FeedTemplate(Builder builder) {
        this.contentObject = builder.contentObject;
        this.socialObject = builder.socialObject;
        this.buttons = builder.buttons;
    }

    @Override
    public String getObjectType() {
        return "feed";
    }

    @Override
    public JSONObject toJSONObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("object_type", (Object)this.getObjectType());
            if (this.contentObject != null) {
                jsonObject.put("content", (Object)this.contentObject.toJSONObject());
            }
            if (this.socialObject != null) {
                jsonObject.put("social", (Object)this.socialObject.toJSONObject());
            }
            if (this.buttons != null) {
                JSONArray buttonArray = new JSONArray();
                for (ButtonObject button : this.buttons) {
                    buttonArray.put((Object)button.toJSONObject());
                }
                jsonObject.put("buttons", (Object)buttonArray);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Builder newBuilder(ContentObject contentObject) {
        return new Builder(contentObject);
    }

    public ContentObject getContentObject() {
        return this.contentObject;
    }

    public static class Builder {
        ContentObject contentObject;
        SocialObject socialObject;
        List<ButtonObject> buttons;

        public Builder(ContentObject contentObject) {
            this.contentObject = contentObject;
            this.buttons = new ArrayList<ButtonObject>();
        }

        public Builder setSocial(SocialObject socialObject) {
            this.socialObject = socialObject;
            return this;
        }

        public Builder addButton(ButtonObject buttonObject) {
            if (buttonObject != null) {
                this.buttons.add(buttonObject);
            }
            return this;
        }

        public FeedTemplate build() {
            return new FeedTemplate(this);
        }
    }
}

