/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import com.kakao.message.template.ButtonObject;
import com.kakao.message.template.ContentObject;
import com.kakao.message.template.LinkObject;
import com.kakao.message.template.TemplateParams;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListTemplate
implements TemplateParams {
    private final String headerTitle;
    private final LinkObject headerLink;
    private final List<ContentObject> contents;
    private final List<ButtonObject> buttons;

    private ListTemplate(Builder builder) {
        this.headerTitle = builder.headerTitle;
        this.headerLink = builder.headerLink;
        this.contents = builder.contents;
        this.buttons = builder.buttons;
    }

    @Override
    public String getObjectType() {
        return "list";
    }

    @Override
    public JSONObject toJSONObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("object_type", (Object)this.getObjectType());
            jsonObject.put("header_title", (Object)this.headerTitle);
            if (this.headerLink != null) {
                jsonObject.put("header_link", (Object)this.headerLink.toJSONObject());
            }
            if (this.contents != null) {
                JSONArray contentsArray = new JSONArray();
                for (ContentObject contentObject : this.contents) {
                    contentsArray.put((Object)contentObject.toJSONObject());
                }
                jsonObject.put("contents", (Object)contentsArray);
            }
            if (this.buttons != null) {
                JSONArray buttonArray = new JSONArray();
                for (ButtonObject button : this.buttons) {
                    buttonArray.put((Object)button.toJSONObject());
                }
                jsonObject.put("buttons", (Object)buttonArray);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Builder newBuilder(String headerTitle, LinkObject headerLink) {
        return new Builder(headerTitle, headerLink);
    }

    public static class Builder {
        private String headerTitle;
        private LinkObject headerLink;
        private List<ContentObject> contents;
        private List<ButtonObject> buttons;

        Builder(String headerTitle, LinkObject headerLink) {
            this.headerTitle = headerTitle;
            this.headerLink = headerLink;
            this.contents = new ArrayList<ContentObject>();
            this.buttons = new ArrayList<ButtonObject>();
        }

        public Builder addContent(ContentObject contentObject) {
            if (this.contents.size() < 3) {
                this.contents.add(contentObject);
            }
            return this;
        }

        public Builder addButton(ButtonObject buttonObject) {
            if (this.buttons != null) {
                this.buttons.add(buttonObject);
            }
            return this;
        }

        public ListTemplate build() {
            return new ListTemplate(this);
        }
    }
}

