/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import com.kakao.message.template.ButtonObject;
import com.kakao.message.template.ContentObject;
import com.kakao.message.template.FeedTemplate;
import com.kakao.message.template.SocialObject;
import com.kakao.message.template.TemplateParams;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationTemplate
implements TemplateParams {
    private final ContentObject contentObject;
    private final SocialObject socialObject;
    private final List<ButtonObject> buttons;
    private final String address;
    private final String addressTitle;

    LocationTemplate(Builder builder) {
        this.address = builder.address;
        this.addressTitle = builder.addressTitle;
        this.contentObject = builder.contentObject;
        this.socialObject = builder.socialObject;
        this.buttons = builder.buttons;
    }

    @Override
    public String getObjectType() {
        return "location";
    }

    @Override
    public JSONObject toJSONObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("object_type", (Object)this.getObjectType());
            jsonObject.put("address", (Object)this.address);
            jsonObject.put("address_title", (Object)this.addressTitle);
            if (this.contentObject != null) {
                jsonObject.put("content", (Object)this.contentObject.toJSONObject());
            }
            if (this.socialObject != null) {
                jsonObject.put("social", (Object)this.socialObject.toJSONObject());
            }
            if (this.buttons != null) {
                JSONArray buttonArray = new JSONArray();
                for (ButtonObject button : this.buttons) {
                    buttonArray.put((Object)button.toJSONObject());
                }
                jsonObject.put("buttons", (Object)buttonArray);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static FeedTemplate.Builder newBuilder(ContentObject contentObject) {
        throw new UnsupportedOperationException("LocationTemplate does not support this method.");
    }

    public static Builder newBuilder(String address, ContentObject contentObject) {
        return new Builder(address, contentObject);
    }

    public static class Builder {
        private final ContentObject contentObject;
        private SocialObject socialObject;
        private List<ButtonObject> buttons;
        private final String address;
        private String addressTitle;

        Builder(String address, ContentObject contentObject) {
            this.address = address;
            this.contentObject = contentObject;
            this.buttons = new ArrayList<ButtonObject>();
        }

        public Builder setSocial(SocialObject socialObject) {
            this.socialObject = socialObject;
            return this;
        }

        public Builder addButton(ButtonObject buttonObject) {
            this.buttons.add(buttonObject);
            return this;
        }

        public Builder setAddressTitle(String addressTitle) {
            this.addressTitle = addressTitle;
            return this;
        }

        public LocationTemplate build() {
            return new LocationTemplate(this);
        }
    }
}

