/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import org.json.JSONException;
import org.json.JSONObject;

public class SocialObject {
    private final Integer likeCount;
    private final Integer commentCount;
    private final Integer sharedCount;
    private final Integer viewCount;
    private final Integer subscriberCount;

    SocialObject(Builder builder) {
        this.likeCount = builder.likeCount;
        this.commentCount = builder.commentCount;
        this.sharedCount = builder.sharedCount;
        this.viewCount = builder.viewCount;
        this.subscriberCount = builder.subscriberCount;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("like_count", (Object)this.likeCount);
        jsonObject.put("comment_count", (Object)this.commentCount);
        jsonObject.put("shared_count", (Object)this.sharedCount);
        jsonObject.put("view_count", (Object)this.viewCount);
        jsonObject.put("subscriber_count", (Object)this.subscriberCount);
        return jsonObject;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getLikeCount() {
        return this.likeCount;
    }

    public Integer getCommentCount() {
        return this.commentCount;
    }

    public Integer getSharedCount() {
        return this.sharedCount;
    }

    public Integer getViewCount() {
        return this.viewCount;
    }

    public Integer getSubscriberCount() {
        return this.subscriberCount;
    }

    public static class Builder {
        private Integer likeCount;
        private Integer commentCount;
        private Integer sharedCount;
        private Integer viewCount;
        private Integer subscriberCount;

        public Builder setLikeCount(int count) {
            this.likeCount = count;
            return this;
        }

        public Builder setCommentCount(int count) {
            this.commentCount = count;
            return this;
        }

        public Builder setSharedCount(int count) {
            this.sharedCount = count;
            return this;
        }

        public Builder setViewCount(int count) {
            this.viewCount = count;
            return this;
        }

        public Builder setSubscriberCount(int count) {
            this.subscriberCount = count;
            return this;
        }

        public SocialObject build() {
            return new SocialObject(this);
        }
    }
}

