/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import android.util.Log;
import com.kakao.message.template.ButtonObject;
import com.kakao.message.template.LinkObject;
import com.kakao.message.template.TemplateParams;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextTemplate
implements TemplateParams {
    private final String text;
    private final LinkObject linkObject;
    private final String buttonTitle;
    private final List<ButtonObject> buttons;

    public TextTemplate(Builder builder) {
        this.text = builder.text;
        this.linkObject = builder.link;
        this.buttonTitle = builder.buttonTitle;
        this.buttons = builder.buttons;
    }

    public static Builder newBuilder(String text, LinkObject linkObject) {
        return new Builder(text, linkObject);
    }

    @Override
    public String getObjectType() {
        return "text";
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("object_type", (Object)this.getObjectType());
            jsonObject.put("text", (Object)this.text);
            jsonObject.put("link", (Object)this.linkObject.toJSONObject());
            jsonObject.put("button_title", (Object)this.buttonTitle);
            if (this.buttons != null) {
                JSONArray buttonArray = new JSONArray();
                for (ButtonObject button : this.buttons) {
                    buttonArray.put((Object)button.toJSONObject());
                }
                jsonObject.put("buttons", (Object)buttonArray);
            }
        }
        catch (JSONException e) {
            Log.w((String)"com.kakao.message", (String)e.toString());
        }
        return jsonObject;
    }

    public List<ButtonObject> getButtons() {
        return this.buttons;
    }

    public LinkObject getLinkObject() {
        return this.linkObject;
    }

    public String getText() {
        return this.text;
    }

    public String getButtonTitle() {
        return this.buttonTitle;
    }

    public static class Builder {
        String text;
        LinkObject link;
        String buttonTitle;
        List<ButtonObject> buttons;

        public Builder(String text, LinkObject linkObject) {
            if (text == null) {
                throw new IllegalArgumentException("TextTemplate's text field cannot be null.");
            }
            if (linkObject == null) {
                throw new IllegalArgumentException("TextTemplate's link field cannot be null.");
            }
            this.text = text;
            this.link = linkObject;
            this.buttons = new ArrayList<ButtonObject>();
        }

        public Builder setButtonTitle(String buttonTitle) {
            this.buttonTitle = buttonTitle;
            return this;
        }

        public Builder addButton(ButtonObject button) {
            if (button != null) {
                this.buttons.add(button);
            }
            return this;
        }

        public TextTemplate build() {
            return new TextTemplate(this);
        }
    }
}

