/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import org.json.JSONException;
import org.json.JSONObject;

public class CommerceDetailObject {
    private final Integer regularPrice;
    private final Integer discountPrice;
    private final Integer discountRate;
    private final Integer fixedDiscountPrice;

    public CommerceDetailObject(Builder builder) {
        this.regularPrice = builder.regularPrice;
        this.discountPrice = builder.discountPrice;
        this.discountRate = builder.discountRate;
        this.fixedDiscountPrice = builder.fixedDiscountPrice;
    }

    public static Builder newBuilder(Integer regularPrice) {
        return new Builder(regularPrice);
    }

    public JSONObject toJSONObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("regular_price", (Object)this.regularPrice);
            jsonObject.put("discount_price", (Object)this.discountPrice);
            jsonObject.put("discount_rate", (Object)this.discountRate);
            jsonObject.put("fixed_discount_price", (Object)this.fixedDiscountPrice);
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static class Builder {
        private Integer regularPrice;
        private Integer discountPrice;
        private Integer discountRate;
        private Integer fixedDiscountPrice;

        Builder(Integer regularPrice) {
            this.regularPrice = regularPrice;
        }

        public Builder setDiscountPrice(Integer discountPrice) {
            this.discountPrice = discountPrice;
            return this;
        }

        public Builder setDiscountRate(Integer discountRate) {
            this.discountRate = discountRate;
            return this;
        }

        public Builder setFixedDiscountPrice(Integer fixedDiscountPrice) {
            this.fixedDiscountPrice = fixedDiscountPrice;
            return this;
        }

        public CommerceDetailObject build() {
            return new CommerceDetailObject(this);
        }
    }
}

