/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import com.kakao.message.template.ButtonObject;
import com.kakao.message.template.CommerceDetailObject;
import com.kakao.message.template.ContentObject;
import com.kakao.message.template.TemplateParams;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommerceTemplate
implements TemplateParams {
    private final ContentObject contentObject;
    private final CommerceDetailObject commerceDetail;
    private final List<ButtonObject> buttons;

    CommerceTemplate(Builder builder) {
        this.contentObject = builder.contentObject;
        this.commerceDetail = builder.commerceDetail;
        this.buttons = builder.buttons;
    }

    @Override
    public String getObjectType() {
        return "commerce";
    }

    @Override
    public JSONObject toJSONObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("object_type", (Object)this.getObjectType());
            if (this.contentObject != null) {
                jsonObject.put("content", (Object)this.contentObject.toJSONObject());
            }
            if (this.commerceDetail != null) {
                jsonObject.put("commerce", (Object)this.commerceDetail.toJSONObject());
            }
            if (this.buttons != null) {
                JSONArray buttonArray = new JSONArray();
                for (ButtonObject button : this.buttons) {
                    buttonArray.put((Object)button.toJSONObject());
                }
                jsonObject.put("buttons", (Object)buttonArray);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Builder newBuilder(ContentObject contentObject, CommerceDetailObject commerceDetail) {
        return new Builder(contentObject, commerceDetail);
    }

    public static class Builder {
        ContentObject contentObject;
        CommerceDetailObject commerceDetail;
        List<ButtonObject> buttons;

        public Builder(ContentObject contentObject, CommerceDetailObject commerceDetail) {
            this.contentObject = contentObject;
            this.commerceDetail = commerceDetail;
            this.buttons = new ArrayList<ButtonObject>();
        }

        public Builder addButton(ButtonObject buttonObject) {
            this.buttons.add(buttonObject);
            return this;
        }

        public CommerceTemplate build() {
            return new CommerceTemplate(this);
        }
    }
}

