/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import com.kakao.message.template.LinkObject;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentObject {
    private String title;
    private String imageUrl;
    private Integer imageWidth;
    private Integer imageHeight;
    private String description;
    private LinkObject link;

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("title", (Object)this.title);
        jsonObject.put("image_url", (Object)this.imageUrl);
        jsonObject.put("image_width", (Object)this.imageWidth);
        jsonObject.put("image_height", (Object)this.imageHeight);
        jsonObject.put("description", (Object)this.description);
        jsonObject.put("link", (Object)this.link.toJSONObject());
        return jsonObject;
    }

    public static Builder newBuilder(String title, String imageUrl, LinkObject link) {
        return new Builder(title, imageUrl, link);
    }

    private ContentObject(Builder builder) {
        this.title = builder.title;
        this.imageUrl = builder.imageUrl;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
        this.description = builder.description;
        this.link = builder.link;
    }

    public String getTitle() {
        return this.title;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public String getDescription() {
        return this.description;
    }

    public LinkObject getLink() {
        return this.link;
    }

    public static class Builder {
        private String title;
        private String imageUrl;
        private Integer imageWidth;
        private Integer imageHeight;
        private String description;
        private LinkObject link;

        public Builder(String title, String imageUrl, LinkObject link) {
            this.title = title;
            this.imageUrl = imageUrl;
            this.link = link;
        }

        public Builder setImageWidth(int width) {
            this.imageWidth = width;
            return this;
        }

        public Builder setImageHeight(int height) {
            this.imageHeight = height;
            return this;
        }

        public Builder setDescrption(String description) {
            this.description = description;
            return this;
        }

        public ContentObject build() {
            return new ContentObject(this);
        }
    }
}

