/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.message.template;

import org.json.JSONException;
import org.json.JSONObject;

public class LinkObject {
    private final String webUrl;
    private final String mobileWebUrl;
    private final String androidExecutionParams;
    private final String iosExecutionParams;

    LinkObject(Builder builder) {
        this.webUrl = builder.webUrl;
        this.mobileWebUrl = builder.mobileWebUrl;
        this.androidExecutionParams = builder.androidExecutionParams;
        this.iosExecutionParams = builder.iosExecutionParams;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("web_url", (Object)this.webUrl);
        jsonObject.put("mobile_web_url", (Object)this.mobileWebUrl);
        jsonObject.put("android_execution_params", (Object)this.androidExecutionParams);
        jsonObject.put("ios_execution_params", (Object)this.iosExecutionParams);
        return jsonObject;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public String getMobileWebUrl() {
        return this.mobileWebUrl;
    }

    public String getAndroidExecutionParams() {
        return this.androidExecutionParams;
    }

    public String getIosExecutionParams() {
        return this.iosExecutionParams;
    }

    public static class Builder {
        private String webUrl;
        private String mobileWebUrl;
        private String androidExecutionParams;
        private String iosExecutionParams;

        public Builder setWebUrl(String url) {
            this.webUrl = url;
            return this;
        }

        public Builder setMobileWebUrl(String url) {
            this.mobileWebUrl = url;
            return this;
        }

        public Builder setAndroidExecutionParams(String params) {
            this.androidExecutionParams = params;
            return this;
        }

        public Builder setIosExecutionParams(String params) {
            this.iosExecutionParams = params;
            return this;
        }

        public LinkObject build() {
            return new LinkObject(this);
        }
    }
}

