/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network;

import android.net.Uri;
import android.os.Build;
import com.kakao.common.IConfiguration;
import com.kakao.common.PhaseInfo;
import com.kakao.network.IRequest;
import com.kakao.network.multipart.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ApiRequest
implements IRequest {
    protected static final String POST = "POST";
    protected static final String GET = "GET";
    protected static final String DELETE = "DELETE";
    private String kaHeader;
    private String extras;
    private String appKey;
    private String appVer;

    protected ApiRequest() {
    }

    protected ApiRequest(PhaseInfo phaseInfo, IConfiguration configuration) {
        this.appKey = phaseInfo.appKey();
        this.kaHeader = configuration.getKAHeader();
        this.extras = configuration.getExtrasJson().toString();
        this.appVer = configuration.getAppVer();
    }

    @Override
    public abstract String getMethod();

    @Override
    public String getUrl() {
        Uri.Builder builder = this.getUriBuilder();
        if (builder != null) {
            return builder.build().toString();
        }
        return "";
    }

    public Uri.Builder getUriBuilder() {
        return new Uri.Builder().scheme("https");
    }

    @Override
    public Map<String, String> getParams() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("KA", this.kaHeader);
        if (!header.containsKey("Content-Type")) {
            header.put("Content-Type", "application/x-www-form-urlencoded");
        }
        if (!header.containsKey("Accept")) {
            header.put("Accept", "*/*");
        }
        if (!header.containsKey("User-Agent")) {
            header.put("User-Agent", this.getHttpUserAgentString());
        }
        header.put("Authorization", "KakaoAK " + this.getAppKey());
        return header;
    }

    @Override
    public List<Part> getMultiPartList() {
        return new ArrayList<Part>();
    }

    @Override
    public String getBodyEncoding() {
        return "UTF-8";
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppVer() {
        return this.appVer;
    }

    public String getExtras() {
        return this.extras;
    }

    public String getHttpUserAgentString() {
        return "os/android-" + Build.VERSION.SDK_INT;
    }

    public void setConfiguration(PhaseInfo phaseInfo, IConfiguration configuration) {
        this.setAppKey(phaseInfo.appKey());
        this.setKaHeader(configuration.getKAHeader());
        this.setAppVer(configuration.getAppVer());
        this.setExtras(configuration.getExtrasJson().toString());
    }

    public void setKaHeader(String kaHeader) {
        this.kaHeader = kaHeader;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppVer(String appVer) {
        this.appVer = appVer;
    }
}

