/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network;

import com.kakao.network.IRequest;
import com.kakao.network.NetworkService;
import com.kakao.network.NetworkTask;
import com.kakao.network.callback.ResponseCallback;
import com.kakao.network.response.ApiResponseStatusError;
import com.kakao.network.response.CustomErrorConverter;
import com.kakao.network.response.ResponseBody;
import com.kakao.network.response.ResponseData;
import com.kakao.network.response.ResponseStringConverter;
import com.kakao.network.tasks.ITaskQueue;
import com.kakao.network.tasks.KakaoResultTask;
import com.kakao.util.helper.log.Logger;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;

class DefaultNetworkService
implements NetworkService {
    private ITaskQueue taskQueue;

    DefaultNetworkService(ITaskQueue taskQueue) {
        this.taskQueue = taskQueue;
    }

    @Override
    public <T> Future<T> request(final IRequest request, final ResponseStringConverter<T> converter, ResponseCallback<T> callback) {
        return this.taskQueue.addTask(new KakaoResultTask<T>(callback){

            @Override
            public T call() throws Exception {
                return DefaultNetworkService.this.request(request, converter);
            }
        });
    }

    @Override
    public <T, E extends Exception> Future<T> request(final IRequest request, final ResponseStringConverter<T> converter, final CustomErrorConverter<E> errorConverter, ResponseCallback<T> callback) {
        return this.taskQueue.addTask(new KakaoResultTask<T>(callback){

            @Override
            public T call() throws Exception {
                return DefaultNetworkService.this.request(request, converter, errorConverter);
            }
        });
    }

    @Override
    public <T> T request(IRequest request, ResponseStringConverter<T> converter) throws IOException, ResponseBody.ResponseBodyException, ApiResponseStatusError {
        NetworkTask task = new NetworkTask();
        ResponseData data = task.request(request);
        Logger.d((String)("" + data.getStringData()));
        if (data.getHttpStatusCode() != 200) {
            ResponseBody errorResponse = new ResponseBody(data.getStringData());
            throw new ApiResponseStatusError(errorResponse.getInt("code"), errorResponse.optString("msg", ""), data.getHttpStatusCode(), errorResponse);
        }
        return converter.convert(data.getStringData());
    }

    @Override
    public <T, E extends Exception> T request(IRequest request, ResponseStringConverter<T> converter, CustomErrorConverter<E> errorConverter) throws IOException, E, ResponseBody.ResponseBodyException {
        NetworkTask task = new NetworkTask();
        ResponseData data = task.request(request);
        Logger.d((String)("" + data.getStringData()));
        if (data.getHttpStatusCode() != 200) {
            throw (Exception)errorConverter.convert(data.getHttpStatusCode(), data.getStringData());
        }
        return converter.convert(data.getStringData());
    }

    @Override
    public <T> Future<List<T>> requestList(final IRequest request, final ResponseStringConverter<T> converter, ResponseCallback<List<T>> callback) {
        return this.taskQueue.addTask(new KakaoResultTask<List<T>>(callback){

            @Override
            public List<T> call() throws Exception {
                return DefaultNetworkService.this.requestList(request, converter);
            }
        });
    }

    @Override
    public <T> List<T> requestList(IRequest request, ResponseStringConverter<T> converter) throws IOException {
        NetworkTask networkTask = new NetworkTask();
        ResponseData data = networkTask.request(request);
        Logger.d((String)("" + data.getStringData()));
        if (data.getHttpStatusCode() != 200 && data.getHttpStatusCode() != 200) {
            ResponseBody errorResponse = new ResponseBody(data.getStringData());
            throw new ApiResponseStatusError(errorResponse.getInt("code"), errorResponse.optString("msg", ""), data.getHttpStatusCode(), errorResponse);
        }
        return converter.convertList(data.getStringData());
    }
}

