/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network;

import com.kakao.network.exception.ResponseStatusError;

public class ErrorResult {
    private final int CLIENT_ERROR_CODE = -777;
    private final int errorCode;
    protected final String errorMessage;
    private final int httpStatus;
    protected final Exception exception;

    public ErrorResult(Exception e) {
        this.errorCode = -777;
        this.errorMessage = e.getMessage();
        this.httpStatus = 500;
        this.exception = e;
    }

    public ErrorResult(ResponseStatusError e) {
        this.errorCode = e.getErrorCode();
        this.errorMessage = e.getErrorMsg();
        this.httpStatus = e.getHttpStatusCode();
        this.exception = e;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ErrorResult)) {
            return false;
        }
        ErrorResult result = (ErrorResult)obj;
        if (this.getErrorCode() != result.getErrorCode()) {
            return false;
        }
        if (this.getHttpStatus() != result.getHttpStatus()) {
            return false;
        }
        return this.getErrorMessage().equals(result.getErrorMessage());
    }

    public String toString() {
        return "ErrorResult{errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + '\'' + ", exception='" + (this.exception != null ? this.exception.toString() : null) + '\'' + '}';
    }
}

