/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network;

import com.kakao.network.INetwork;
import com.kakao.network.multipart.MultipartRequestEntity;
import com.kakao.network.multipart.Part;
import com.kakao.util.helper.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class KakaoNetworkImpl
implements INetwork {
    private static final String ISO_CHARSET = "ISO-8859-1";
    private static final int DEFAULT_CONNECTION_TO_IN_MS = 5000;
    private static final int DEFAULT_REQUEST_TO_IN_MS = 30000;
    private final List<Part> parts = new ArrayList<Part>();
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<String, String> header = new HashMap<String, String>();
    private HttpURLConnection urlConnection = null;
    private String charset = "ISO-8859-1";
    private int statusCode = -1;
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    @Override
    public void create(String url, String method, String charset) throws IOException {
        Logger.d((String)("++ url: " + url));
        Logger.d((String)("++ method: " + method));
        this.charset = charset;
        this.urlConnection = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
        if (url.startsWith("https")) {
            HttpsURLConnection secure = (HttpsURLConnection)this.urlConnection;
            secure.setHostnameVerifier(DO_NOT_VERIFY);
        }
        this.urlConnection.setRequestMethod(method);
    }

    @Override
    public void configure() throws IOException {
        String reqType;
        this.urlConnection.setDoInput(true);
        this.urlConnection.setConnectTimeout(5000);
        this.urlConnection.setReadTimeout(30000);
        this.urlConnection.setInstanceFollowRedirects(false);
        this.urlConnection.setRequestProperty("Connection", "keep-alive");
        if (!this.header.isEmpty()) {
            for (String key : this.header.keySet()) {
                this.urlConnection.setRequestProperty(key, this.header.get(key));
            }
        }
        if ("POST".equals(reqType = this.urlConnection.getRequestMethod()) || "PUT".equals(reqType)) {
            this.urlConnection.setRequestProperty("Content-Length", "0");
            this.urlConnection.setDoOutput(true);
            int contentLength = 0;
            String postParamString = null;
            MultipartRequestEntity mre = null;
            if (!this.params.isEmpty()) {
                postParamString = this.getPostDataString(this.params);
                contentLength += postParamString.length();
            } else if (!this.parts.isEmpty()) {
                mre = new MultipartRequestEntity(this.parts);
                contentLength = (int)((long)contentLength + mre.getContentLength());
                this.urlConnection.setRequestProperty("Content-Type", mre.getContentType());
            }
            if (contentLength > 0) {
                this.urlConnection.setFixedLengthStreamingMode(contentLength);
                this.urlConnection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            }
            if (postParamString != null && !postParamString.isEmpty()) {
                this.urlConnection.getOutputStream().write(postParamString.getBytes(this.charset));
            }
            if (mre != null) {
                mre.writeRequest(this.urlConnection.getOutputStream());
            }
        }
    }

    @Override
    public void connect() throws IOException {
        try {
            this.statusCode = this.urlConnection.getResponseCode();
        }
        catch (IOException e) {
            this.statusCode = this.urlConnection.getResponseCode();
        }
    }

    @Override
    public void disconnect() {
        this.params.clear();
        this.header.clear();
        this.parts.clear();
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
        this.statusCode = 200;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void addHeader(String key, String value) {
        this.header.put(key, value);
    }

    @Override
    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFully() throws IOException {
        InputStream is = this.getInputStream(this.urlConnection);
        try {
            int nLength;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] byteBuffer = new byte[1024];
            while ((nLength = is.read(byteBuffer, 0, byteBuffer.length)) != -1) {
                baos.write(byteBuffer, 0, nLength);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void addPart(Part part) {
        this.parts.add(part);
    }

    private String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), this.charset));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), this.charset));
        }
        return result.toString();
    }

    private InputStream getInputStream(HttpURLConnection urlConnection) throws IOException {
        if (urlConnection.getResponseCode() < 400) {
            return urlConnection.getInputStream();
        }
        InputStream ein = urlConnection.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }
}

