/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network;

import com.kakao.network.INetwork;
import com.kakao.network.IRequest;
import com.kakao.network.KakaoNetworkImpl;
import com.kakao.network.multipart.Part;
import com.kakao.network.response.ResponseData;
import com.kakao.util.helper.log.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class NetworkTask {
    private final INetwork network;

    public NetworkTask() {
        this.network = new KakaoNetworkImpl();
    }

    public NetworkTask(INetwork network) {
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData request(IRequest request) throws IOException {
        try {
            this.network.create(request.getUrl(), request.getMethod(), request.getBodyEncoding());
            Map<String, String> header = request.getHeaders();
            Logger.d((String)header.toString());
            for (String string : header.keySet()) {
                if (string.equalsIgnoreCase("Expect")) {
                    throw new IllegalStateException("Expect: 100-Continue not supported");
                }
                this.network.addHeader(string, header.get(string));
            }
            Map<String, String> params = request.getParams();
            for (String string : params.keySet()) {
                this.network.addParam(string, params.get(string));
            }
            List<Part> list = request.getMultiPartList();
            for (Part part : list) {
                this.network.addPart(part);
            }
            this.network.configure();
            this.network.connect();
            int n = this.network.getStatusCode();
            Logger.d((String)"++ httpStatus : [%s]", (Object[])new Object[]{n});
            ResponseData responseData = new ResponseData(n, this.network.readFully());
            return responseData;
        }
        finally {
            this.network.disconnect();
        }
    }
}

