/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.multipart;

import com.kakao.network.multipart.MultipartRequestEntity;
import com.kakao.network.multipart.Part;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePart
extends Part {
    private static final String FILE_NAME = "; filename=";
    private static final String DEFAULT_FILE_PART_CONTENT_TYPE = "application/octet-stream";
    private static final String DEFAULT_FILE_PART_CHARSET = "ISO-8859-1";
    private static final String DEFAULT_FILE_PART_TRANSFER_ENCODING = "binary";
    private static final byte[] FILE_NAME_BYTES = MultipartRequestEntity.getAsciiBytes("; filename=");
    private final File content;

    public FilePart(String fieldName, File content) {
        this(fieldName, content, DEFAULT_FILE_PART_CONTENT_TYPE, DEFAULT_FILE_PART_CHARSET, DEFAULT_FILE_PART_TRANSFER_ENCODING);
    }

    public FilePart(String fieldName, File content, String contentType, String charset, String transferEncoding) {
        super(fieldName, contentType == null || contentType.isEmpty() ? DEFAULT_FILE_PART_CONTENT_TYPE : contentType, charset == null || charset.isEmpty() ? DEFAULT_FILE_PART_CHARSET : charset, transferEncoding == null || transferEncoding.isEmpty() ? DEFAULT_FILE_PART_TRANSFER_ENCODING : transferEncoding);
        this.content = content;
    }

    @Override
    protected void sendDispositionHeader(OutputStream out) throws IOException {
        super.sendDispositionHeader(out);
        String filename = this.content.getName();
        if (filename != null) {
            out.write(FILE_NAME_BYTES);
            out.write(QUOTE_BYTES);
            out.write(MultipartRequestEntity.getAsciiBytes(filename));
            out.write(QUOTE_BYTES);
        }
    }

    @Override
    protected long dispositionHeaderLength() {
        String filename = this.content.getName();
        long length = super.dispositionHeaderLength();
        if (filename != null) {
            length += (long)FILE_NAME_BYTES.length;
            length += (long)QUOTE_BYTES.length;
            length += (long)MultipartRequestEntity.getAsciiBytes(filename).length;
            length += (long)QUOTE_BYTES.length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendData(OutputStream out) throws IOException {
        if (this.lengthOfData() == 0L) {
            return;
        }
        byte[] tmp = new byte[4096];
        try (InputStream instream = this.content != null ? new FileInputStream(this.content) : new ByteArrayInputStream(new byte[0]);){
            int len;
            while ((len = instream.read(tmp)) >= 0) {
                out.write(tmp, 0, len);
            }
        }
    }

    @Override
    protected long lengthOfData() {
        if (this.content != null) {
            return this.content.length();
        }
        return 0L;
    }
}

