/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.multipart;

import com.kakao.network.multipart.Part;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Random;

public class MultipartRequestEntity {
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static final byte[] MULTIPART_CHARS = MultipartRequestEntity.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    private static final String ASCII_CHARSET_NAME = "US-ASCII";
    private static final Random RANDOM = new Random();
    private final List<Part> parts;
    private final byte[] multipartBoundary;
    private final String contentType;
    private final long contentLength;

    public static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        try {
            return data.getBytes(ASCII_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException var2) {
            throw new RuntimeException(var2);
        }
    }

    public static byte[] getBytes(String data, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.isEmpty()) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException var3) {
            throw new IllegalArgumentException(String.format("Unsupported encoding: %s", charset));
        }
    }

    private static byte[] generateMultipartBoundary() {
        byte[] bytes = new byte[RANDOM.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[RANDOM.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    public MultipartRequestEntity(List<Part> parts) {
        this.parts = parts;
        this.multipartBoundary = MultipartRequestEntity.generateMultipartBoundary();
        this.contentType = this.computeContentType(MULTIPART_FORM_CONTENT_TYPE);
        this.contentLength = Part.getLengthOfParts(parts, this.multipartBoundary);
    }

    private String computeContentType(String base) {
        StringBuilder buffer = new StringBuilder(base);
        if (!base.endsWith(";")) {
            buffer.append(";");
        }
        try {
            return buffer.append(" boundary=").append(new String(this.multipartBoundary, ASCII_CHARSET_NAME)).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeRequest(OutputStream out) throws IOException {
        Part.sendParts(out, this.parts, this.multipartBoundary);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }
}

