/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.multipart;

import com.kakao.network.multipart.MultipartRequestEntity;
import com.kakao.util.helper.log.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class Part {
    private static final String CRLF = "\r\n";
    private static final String QUOTE = "\"";
    private static final String EXTRA = "--";
    private static final String CHARSET = "; charset=";
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: ";
    protected static final byte[] CRLF_BYTES = MultipartRequestEntity.getAsciiBytes("\r\n");
    protected static final byte[] QUOTE_BYTES = MultipartRequestEntity.getAsciiBytes("\"");
    protected static final byte[] EXTRA_BYTES = MultipartRequestEntity.getAsciiBytes("--");
    protected static final byte[] CHARSET_BYTES = MultipartRequestEntity.getAsciiBytes("; charset=");
    protected static final byte[] CONTENT_TYPE_BYTES = MultipartRequestEntity.getAsciiBytes("Content-Type: ");
    protected static final byte[] CONTENT_DISPOSITION_BYTES = MultipartRequestEntity.getAsciiBytes("Content-Disposition: form-data; name=");
    protected static final byte[] CONTENT_TRANSFER_ENCODING_BYTES = MultipartRequestEntity.getAsciiBytes("Content-Transfer-Encoding: ");
    protected final String name;
    protected final String contentTypeString;
    protected final String charsetString;
    protected final String transferEncodingString;

    protected Part(String name, String contentTypeString, String charsetString, String transferEncodingString) {
        this.name = name;
        this.contentTypeString = contentTypeString;
        this.charsetString = charsetString;
        this.transferEncodingString = transferEncodingString;
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    public String getName() {
        return this.name;
    }

    public String getCharSet() {
        return this.charsetString;
    }

    public String getTransferEncoding() {
        return this.transferEncodingString;
    }

    public String getContentType() {
        return this.contentTypeString;
    }

    protected abstract long lengthOfData();

    static long getLengthOfParts(List<Part> parts, byte[] partBoundary) {
        try {
            if (parts == null) {
                throw new IllegalArgumentException("Parts may not be null");
            }
            long total = 0L;
            for (Part part : parts) {
                long l = part.length(partBoundary);
                if (l < 0L) {
                    return -1L;
                }
                total += l;
            }
            total += (long)EXTRA_BYTES.length;
            total += (long)partBoundary.length;
            total += (long)EXTRA_BYTES.length;
            return total += (long)CRLF_BYTES.length;
        }
        catch (Exception e) {
            Logger.e((String)"An exception occurred while getting the length of the parts", (Throwable)e);
            return 0L;
        }
    }

    public long length(byte[] boundary) {
        long lengthOfData = this.lengthOfData();
        return lengthOfData < 0L ? -1L : lengthOfData + (long)this.startLength(boundary) + this.dispositionHeaderLength() + this.contentTypeHeaderLength() + this.transferEncodingHeaderLength() + this.endOfHeaderLength() + this.endLength();
    }

    public static void sendParts(OutputStream out, List<Part> parts, byte[] boundary) throws IOException {
        if (parts == null || parts.isEmpty()) {
            throw new IllegalArgumentException("Parts may not be null or empty");
        }
        if (boundary == null || boundary.length <= 0) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        for (Part part : parts) {
            part.sendStart(out, boundary);
            part.sendDispositionHeader(out);
            part.sendContentTypeHeader(out);
            part.sendTransferEncodingHeader(out);
            part.sendEndOfHeader(out);
            part.sendData(out);
            part.sendEnd(out);
        }
        out.write(EXTRA_BYTES);
        out.write(boundary);
        out.write(EXTRA_BYTES);
        out.write(CRLF_BYTES);
    }

    protected void sendStart(OutputStream out, byte[] boundary) throws IOException {
        out.write(EXTRA_BYTES);
        out.write(boundary);
    }

    protected int startLength(byte[] boundary) {
        return EXTRA_BYTES.length + boundary.length;
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        String name = this.name;
        if (name != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_DISPOSITION_BYTES);
            out.write(QUOTE_BYTES);
            out.write(MultipartRequestEntity.getAsciiBytes(name));
            out.write(QUOTE_BYTES);
        }
    }

    protected long dispositionHeaderLength() {
        long length = 0L;
        String name = this.name;
        if (name != null && !name.isEmpty()) {
            length += (long)CRLF_BYTES.length;
            length += (long)CONTENT_DISPOSITION_BYTES.length;
            length += (long)QUOTE_BYTES.length;
            length += (long)MultipartRequestEntity.getAsciiBytes(name).length;
            length += (long)QUOTE_BYTES.length;
        }
        return length;
    }

    protected void sendContentTypeHeader(OutputStream out) throws IOException {
        String contentType = this.contentTypeString;
        if (contentType != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TYPE_BYTES);
            out.write(MultipartRequestEntity.getAsciiBytes(contentType));
            String charSet = this.charsetString;
            if (charSet != null) {
                out.write(CHARSET_BYTES);
                out.write(MultipartRequestEntity.getAsciiBytes(charSet));
            }
        }
    }

    protected long contentTypeHeaderLength() {
        long length = 0L;
        String contentType = this.contentTypeString;
        if (contentType != null) {
            length += (long)CRLF_BYTES.length;
            length += (long)CONTENT_TYPE_BYTES.length;
            length += (long)MultipartRequestEntity.getAsciiBytes(contentType).length;
            String charSet = this.charsetString;
            if (charSet != null) {
                length += (long)CHARSET_BYTES.length;
                length += (long)MultipartRequestEntity.getAsciiBytes(charSet).length;
            }
        }
        return length;
    }

    protected void sendTransferEncodingHeader(OutputStream out) throws IOException {
        String transferEncoding = this.transferEncodingString;
        if (transferEncoding != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TRANSFER_ENCODING_BYTES);
            out.write(MultipartRequestEntity.getAsciiBytes(transferEncoding));
        }
    }

    protected long transferEncodingHeaderLength() {
        long length = 0L;
        String transferEncoding = this.transferEncodingString;
        if (transferEncoding != null) {
            length += (long)CRLF_BYTES.length;
            length += (long)CONTENT_TRANSFER_ENCODING_BYTES.length;
            length += (long)MultipartRequestEntity.getAsciiBytes(transferEncoding).length;
        }
        return length;
    }

    protected void sendEndOfHeader(OutputStream out) throws IOException {
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    protected long endOfHeaderLength() {
        return CRLF_BYTES.length * 2;
    }

    protected void sendEnd(OutputStream out) throws IOException {
        out.write(CRLF_BYTES);
    }

    protected long endLength() {
        return CRLF_BYTES.length;
    }
}

