/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.multipart;

import com.kakao.network.multipart.MultipartRequestEntity;
import com.kakao.network.multipart.Part;
import java.io.IOException;
import java.io.OutputStream;

public class StringPart
extends Part {
    private static final String DEFAULT_STRING_PART_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_STRING_PART_CHARSET = "UTF-8";
    private static final String DEFAULT_STRING_PART_TRANSFER_ENCODING = "8bit";
    private final String value;
    private byte[] content;

    public StringPart(String fieldName, String value) {
        this(fieldName, value, DEFAULT_STRING_PART_CONTENT_TYPE, DEFAULT_STRING_PART_CHARSET, DEFAULT_STRING_PART_TRANSFER_ENCODING);
    }

    public StringPart(String fieldName, String value, String contentType, String charset, String transferEncoding) {
        super(fieldName, contentType == null || contentType.isEmpty() ? DEFAULT_STRING_PART_CONTENT_TYPE : contentType, charset == null || charset.isEmpty() ? DEFAULT_STRING_PART_CHARSET : charset, transferEncoding == null || transferEncoding.isEmpty() ? DEFAULT_STRING_PART_TRANSFER_ENCODING : transferEncoding);
        this.value = value;
    }

    @Override
    protected void sendData(OutputStream out) throws IOException {
        out.write(this.getContent());
    }

    @Override
    protected long lengthOfData() {
        return this.getContent().length;
    }

    private byte[] getContent() {
        if (this.content == null) {
            this.content = MultipartRequestEntity.getBytes(this.value, this.charsetString);
        }
        return this.content;
    }
}

