/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.response;

import com.kakao.network.response.ResponseBodyArray;
import com.kakao.network.response.ResponseData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseBody {
    private JSONObject json = null;
    private int statusCode;

    @Deprecated
    public int getStatusCode() {
        return this.statusCode;
    }

    public JSONObject getBody() {
        return this.json;
    }

    @Deprecated
    public ResponseBody(ResponseData data) throws ResponseBodyException {
        this(data.getHttpStatusCode(), data.getData());
    }

    @Deprecated
    public ResponseBody(int statusCode, byte[] body) throws ResponseBodyException {
        this.statusCode = statusCode;
        if (body == null) {
            throw new ResponseBodyException("Response body is null.");
        }
        if (body.length != 0) {
            try {
                this.json = new JSONObject(new String(body));
            }
            catch (JSONException e) {
                throw new ResponseBodyException((Exception)((Object)e));
            }
        }
    }

    @Deprecated
    public ResponseBody(int statusCode, JSONObject body) throws ResponseBodyException {
        this.statusCode = statusCode;
        if (body == null) {
            throw new ResponseBodyException();
        }
        this.json = body;
    }

    public ResponseBody(JSONObject jsonObject) throws ResponseBodyException {
        if (jsonObject == null) {
            throw new ResponseBodyException();
        }
        this.json = jsonObject;
    }

    public ResponseBody(String stringData) throws ResponseBodyException {
        try {
            this.json = new JSONObject(stringData);
        }
        catch (JSONException e) {
            throw new ResponseBodyException((Exception)((Object)e));
        }
    }

    private Object getOrThrow(String key) {
        Object v = null;
        try {
            v = this.json.get(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (v == null) {
            throw new NoSuchElementException(key);
        }
        if (v == JSONObject.NULL) {
            return null;
        }
        return v;
    }

    public long getLong(String key) throws ResponseBodyException {
        try {
            Object obj = this.getOrThrow(key);
            if (obj instanceof Integer) {
                return ((Integer)obj).intValue();
            }
            if (obj instanceof Long) {
                return (Long)obj;
            }
            throw new ResponseBodyException();
        }
        catch (ResponseBodyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    public int getInt(String key) throws ResponseBodyException {
        try {
            return (Integer)this.getOrThrow(key);
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    public boolean has(String key) {
        return this.json.has(key);
    }

    public int optInt(String key, int def) {
        if (this.has(key)) {
            try {
                return this.getInt(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String key) throws ResponseBodyException {
        try {
            return (String)this.getOrThrow(key);
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    public String optString(String key, String def) {
        if (this.has(key)) {
            try {
                return this.getString(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public boolean getBoolean(String key) throws ResponseBodyException {
        try {
            return (Boolean)this.getOrThrow(key);
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    @Deprecated
    public ResponseBodyArray getArray(String key) throws ResponseBodyException {
        try {
            return new ResponseBodyArray((JSONArray)this.getOrThrow(key));
        }
        catch (ResponseBodyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    @Deprecated
    public ResponseBodyArray optArray(String key, ResponseBodyArray def) {
        if (this.has(key)) {
            try {
                return this.getArray(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public JSONArray getJSONArray(String key) throws ResponseBodyException {
        try {
            return (JSONArray)this.getOrThrow(key);
        }
        catch (ResponseBodyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    public JSONArray optJSONArray(String key, JSONArray def) {
        if (this.has(key)) {
            try {
                return this.getJSONArray(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public ResponseBody getBody(String key) throws ResponseBodyException {
        try {
            return new ResponseBody((JSONObject)this.getOrThrow(key));
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    public ResponseBody optBody(String key, ResponseBody def) {
        if (this.has(key)) {
            try {
                return this.getBody(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public boolean optBoolean(String key, boolean def) {
        if (this.has(key)) {
            try {
                return this.getBoolean(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public long optLong(String key, long def) {
        if (this.has(key)) {
            try {
                return this.getLong(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public JSONObject getJSONObject(String key) {
        try {
            return (JSONObject)this.getOrThrow(key);
        }
        catch (ResponseBodyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResponseBodyException(e);
        }
    }

    public JSONObject optJSONObject(String key, JSONObject def) {
        if (this.has(key)) {
            try {
                return this.getJSONObject(key);
            }
            catch (ResponseBodyException responseBodyException) {
                // empty catch block
            }
        }
        return def;
    }

    public String toString() {
        return this.json.toString();
    }

    private Iterator<String> getKeys() {
        return this.json == null ? null : this.json.keys();
    }

    public static <T> Map<String, T> toMap(ResponseBody body) throws ResponseBodyException {
        HashMap map = new HashMap();
        Iterator<String> keysItr = body.getKeys();
        while (keysItr.hasNext()) {
            String key = keysItr.next();
            List value = body.getOrThrow(key);
            if (value instanceof JSONArray) {
                value = ResponseBodyArray.toList(new ResponseBodyArray((JSONArray)value));
            } else if (value instanceof JSONObject) {
                value = ResponseBody.toMap(new ResponseBody((JSONObject)value));
            }
            map.put(key, value);
        }
        return map;
    }

    public static class ResponseBodyException
    extends RuntimeException {
        private static final long serialVersionUID = 8171429617556607125L;

        public ResponseBodyException() {
        }

        public ResponseBodyException(String errMsg) {
            super(errMsg);
        }

        public ResponseBodyException(Exception e) {
            super(e);
        }
    }
}

