/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.response;

import com.kakao.network.response.ResponseConverter;
import com.kakao.util.helper.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class ResponseStringConverter<T>
implements ResponseConverter<String, T> {
    public static final ResponseStringConverter<String> IDENTITY_CONVERTER = new ResponseStringConverter<String>(){

        @Override
        public String convert(String data) {
            return data;
        }
    };

    @Override
    public String fromArray(JSONArray array, int i) {
        try {
            return array.getString(i);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public List<T> convertList(String data) {
        ArrayList result = new ArrayList();
        try {
            JSONArray array = new JSONArray(data);
            return this.convertList(array);
        }
        catch (JSONException e) {
            Logger.w((String)e.toString());
            return result;
        }
    }

    public List<T> convertList(JSONArray array) {
        ArrayList result = new ArrayList();
        if (array == null) {
            return result;
        }
        for (int i = 0; i < array.length(); ++i) {
            String element = this.fromArray(array, i);
            result.add(this.convert(element));
        }
        return result;
    }
}

