/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.storage;

import android.net.Uri;
import com.kakao.common.IConfiguration;
import com.kakao.common.PhaseInfo;
import com.kakao.network.ApiRequest;
import com.kakao.network.ServerProtocol;

public class ImageScrapRequest
extends ApiRequest {
    private String imageUrl;
    private Boolean secureResource;

    protected ImageScrapRequest(PhaseInfo phaseInfo, IConfiguration configuration, String imageUrl, Boolean secureResource) {
        super(phaseInfo, configuration);
        this.imageUrl = imageUrl;
        this.secureResource = secureResource;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Uri.Builder getUriBuilder() {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https");
        builder.authority(ServerProtocol.apiAuthority());
        if (this.secureResource.booleanValue()) {
            builder.appendQueryParameter("secure_resource", String.valueOf(this.secureResource));
        }
        if (this.imageUrl != null) {
            builder.appendQueryParameter("image_url", this.imageUrl);
        }
        return builder;
    }
}

