/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.storage;

import android.net.Uri;
import com.kakao.common.IConfiguration;
import com.kakao.common.PhaseInfo;
import com.kakao.network.ApiRequest;
import com.kakao.network.ServerProtocol;
import com.kakao.network.multipart.FilePart;
import com.kakao.network.multipart.Part;
import java.io.File;
import java.util.List;
import java.util.Map;

public class ImageUploadRequest
extends ApiRequest {
    private Boolean secureResource;
    private File imageFile;

    protected ImageUploadRequest(PhaseInfo phaseInfo, IConfiguration configuration, Boolean secureResource, File imageFile) {
        super(phaseInfo, configuration);
        this.secureResource = secureResource;
        this.imageFile = imageFile;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Uri.Builder getUriBuilder() {
        Uri.Builder builder = super.getUriBuilder().authority(ServerProtocol.apiAuthority());
        if (this.secureResource.booleanValue()) {
            builder.appendQueryParameter("secure_resource", String.valueOf(this.secureResource));
        }
        return builder;
    }

    @Override
    public Map<String, String> getParams() {
        return super.getParams();
    }

    @Override
    public List<Part> getMultiPartList() {
        List<Part> filePart = super.getMultiPartList();
        if (this.imageFile != null && this.imageFile.exists()) {
            filePart.add(new FilePart("file", this.imageFile));
        }
        return filePart;
    }
}

