/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.network.tasks;

import android.os.Handler;
import android.os.Looper;
import com.kakao.network.ErrorResult;
import com.kakao.network.callback.ResponseCallback;
import com.kakao.network.exception.ResponseStatusError;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public abstract class KakaoResultTask<T> {
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    final ResponseCallback<T> callback;
    private final Callable<T> task = new Callable<T>(){

        @Override
        public T call() throws Exception {
            Object result = null;
            Exception ex = null;
            try {
                if (KakaoResultTask.this.callback != null) {
                    KakaoResultTask.this.callback.onDidStart();
                }
                KakaoResultTask.this.onDidStart();
                result = KakaoResultTask.this.call();
            }
            catch (Exception e) {
                ex = e;
            }
            final Object response = result;
            final Exception t = ex;
            final CountDownLatch lock = new CountDownLatch(1);
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (KakaoResultTask.this.callback == null) {
                            return;
                        }
                        if (t != null) {
                            ErrorResult errorResult;
                            if (t instanceof ResponseStatusError) {
                                ResponseStatusError err = (ResponseStatusError)t;
                                errorResult = new ErrorResult(err);
                            } else {
                                errorResult = new ErrorResult(t);
                            }
                            KakaoResultTask.this.callback.onFailureForUiThread(errorResult);
                        } else {
                            KakaoResultTask.this.callback.onSuccessForUiThread(response);
                        }
                    }
                    finally {
                        lock.countDown();
                    }
                }
            });
            lock.await();
            KakaoResultTask.this.onDidEnd();
            if (KakaoResultTask.this.callback != null) {
                KakaoResultTask.this.callback.onDidEnd();
            }
            return result;
        }
    };

    public KakaoResultTask() {
        this.callback = null;
    }

    public KakaoResultTask(ResponseCallback<T> callback) {
        this.callback = callback;
    }

    public abstract T call() throws Exception;

    public final Callable<T> getCallable() {
        return this.task;
    }

    public void onDidStart() {
    }

    public void onDidEnd() {
    }
}

