/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.common.network;

import com.kakao.sdk.common.model.ApiError;
import com.kakao.sdk.common.model.ApiErrorCause;
import com.kakao.sdk.common.model.ApiErrorResponse;
import com.kakao.sdk.common.model.KakaoSdkError;
import com.kakao.sdk.common.util.KakaoJson;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u0011*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00018\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\bH\u0016J$\u0010\u000e\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/kakao/sdk/common/network/ApiCallback;", "T", "Lretrofit2/Callback;", "()V", "onComplete", "", "model", "error", "", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "onFailure", "call", "Lretrofit2/Call;", "t", "onResponse", "response", "Lretrofit2/Response;", "Companion", "common_release"})
public abstract class ApiCallback<T>
implements Callback<T> {
    public static final Companion Companion = new Companion(null);

    public abstract void onComplete(@Nullable T var1, @Nullable Throwable var2);

    public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull(call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        if (t.getCause() instanceof KakaoSdkError) {
            this.onComplete(null, t.getCause());
        } else {
            this.onComplete(null, t);
        }
    }

    public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
        Intrinsics.checkParameterIsNotNull(call, (String)"call");
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        Object model = response.body();
        if (model != null) {
            this.onComplete(model, null);
        } else {
            this.onFailure(call, Companion.translateError((Throwable)new HttpException(response)));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/kakao/sdk/common/network/ApiCallback$Companion;", "", "()V", "translateError", "", "t", "common_release"})
    public static final class Companion {
        @NotNull
        public final Throwable translateError(@NotNull Throwable t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            try {
                if (t instanceof HttpException) {
                    ApiErrorResponse response;
                    ApiErrorCause apiErrorCause;
                    String errorString;
                    Response response2 = ((HttpException)t).response();
                    String string = errorString = response2 != null && (response2 = response2.errorBody()) != null ? response2.string() : null;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((apiErrorCause = (ApiErrorCause)((Object)KakaoJson.INSTANCE.fromJson(String.valueOf((response = (ApiErrorResponse)KakaoJson.INSTANCE.fromJson(string, (Type)((Object)ApiErrorResponse.class))).getCode()), (Type)((Object)ApiErrorCause.class)))) == null) {
                        apiErrorCause = ApiErrorCause.Unknown;
                    }
                    ApiErrorCause cause = apiErrorCause;
                    return new ApiError(((HttpException)t).code(), cause, response);
                }
                return t;
            }
            catch (Throwable unexpected) {
                return unexpected;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

