/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.common.util;

import android.util.Base64;
import com.kakao.sdk.common.KakaoSdk;
import com.kakao.sdk.common.model.ContextInfo;
import com.kakao.sdk.common.util.Cipher;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/kakao/sdk/common/util/AESCipher;", "Lcom/kakao/sdk/common/util/Cipher;", "contextInfo", "Lcom/kakao/sdk/common/model/ContextInfo;", "(Lcom/kakao/sdk/common/model/ContextInfo;)V", "CHAR_SET", "Ljava/nio/charset/Charset;", "ITER_COUNT", "", "IV_PARAMETER_SPEC", "Ljavax/crypto/spec/IvParameterSpec;", "KEY_LENGTH", "algorithm", "", "cipherAlgorithm", "decryptor", "Ljavax/crypto/Cipher;", "encryptor", "initVector", "", "keyGenAlgorithm", "base64DecodeAndXor", "source", "decrypt", "encrypted", "encrypt", "value", "xorMessage", "message", "key", "common_release"})
public final class AESCipher
implements Cipher {
    private final String keyGenAlgorithm;
    private final String cipherAlgorithm;
    private final String algorithm = "AES";
    private final int ITER_COUNT = 2;
    private final int KEY_LENGTH = 256;
    private final Charset CHAR_SET;
    private final javax.crypto.Cipher encryptor;
    private final javax.crypto.Cipher decryptor;
    private final byte[] initVector;
    private final IvParameterSpec IV_PARAMETER_SPEC;

    @Override
    @NotNull
    public String encrypt(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        Charset charset = this.CHAR_SET;
        javax.crypto.Cipher cipher = this.encryptor;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String string2 = Base64.encodeToString((byte[])cipher.doFinal(byArray2), (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(en\u2026AR_SET)), Base64.NO_WRAP)");
        return string2;
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String encrypted) {
        Intrinsics.checkParameterIsNotNull((Object)encrypted, (String)"encrypted");
        byte[] byArray = this.decryptor.doFinal(Base64.decode((String)encrypted, (int)2));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"decryptor.doFinal(Base64\u2026crypted, Base64.NO_WRAP))");
        byte[] byArray2 = byArray;
        Charset charset = this.CHAR_SET;
        boolean bl = false;
        boolean bl2 = false;
        return new String(byArray2, charset);
    }

    private final String xorMessage(String message) {
        return this.xorMessage(message, "com.kakao.api");
    }

    /*
     * WARNING - void declaration
     */
    private final String xorMessage(String message, String key) {
        try {
            if (message == null || key == null) {
                return null;
            }
            String string = key;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] keys = cArray;
            String string2 = message;
            boolean bl2 = false;
            char[] cArray2 = string2.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            char[] msg = cArray2;
            int ml = msg.length;
            int kl = keys.length;
            char[] newMsg = new char[ml];
            int n = 0;
            int n2 = ml;
            while (n < n2) {
                void i;
                byte by = (byte)msg[i];
                byte by2 = (byte)keys[i % kl];
                void var14_17 = i++;
                char[] cArray3 = newMsg;
                boolean bl3 = false;
                byte by3 = (byte)(by ^ by2);
                cArray3[var14_17] = (char)by3;
            }
            n = 0;
            return new String(newMsg);
        }
        catch (Exception e) {
            return null;
        }
    }

    private final String base64DecodeAndXor(String source) {
        byte[] byArray = Base64.decode((String)source, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(source, Base64.DEFAULT)");
        byte[] byArray2 = byArray;
        AESCipher aESCipher = this;
        boolean bl = false;
        String string = new String(byArray2, Charsets.UTF_8);
        return aESCipher.xorMessage(string);
    }

    public AESCipher(@NotNull ContextInfo contextInfo) {
        SecretKey tmp;
        Intrinsics.checkParameterIsNotNull((Object)contextInfo, (String)"contextInfo");
        this.keyGenAlgorithm = this.base64DecodeAndXor("My0oeSI1IzInbyA+LVFaW2wiNSokPAMiMipOLS4=");
        this.cipherAlgorithm = this.base64DecodeAndXor("Iio+ASgjKE4/ZSIjXDMOCUoCDww=");
        this.algorithm = "AES";
        this.ITER_COUNT = 2;
        this.KEY_LENGTH = 256;
        this.CHAR_SET = Charsets.UTF_8;
        this.initVector = new byte[]{112, 78, 75, 55, -54, -30, -10, 44, 102, -126, -126, 92, -116, -48, -123, -55};
        this.IV_PARAMETER_SPEC = new IvParameterSpec(this.initVector);
        String keyValue = contextInfo.getSigningKeyHash();
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.keyGenAlgorithm);
        String string = keyValue;
        int n = 0;
        int n2 = Math.min(keyValue.length(), 16);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Object object = string3;
        string = object;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string4.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        int n3 = this.KEY_LENGTH;
        int n4 = this.ITER_COUNT;
        byte[] byArray = contextInfo.getSalt();
        Object object2 = object;
        PBEKeySpec keySpec = new PBEKeySpec((char[])object2, byArray, n4, n3);
        SecretKey secretKey = tmp = factory.generateSecret(keySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"tmp");
        SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), this.algorithm);
        javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(this.cipherAlgorithm);
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher, (String)"Cipher.getInstance(cipherAlgorithm)");
        this.encryptor = cipher;
        javax.crypto.Cipher cipher2 = javax.crypto.Cipher.getInstance(this.cipherAlgorithm);
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"Cipher.getInstance(cipherAlgorithm)");
        this.decryptor = cipher2;
        try {
            this.encryptor.init(1, (Key)secret, this.IV_PARAMETER_SPEC);
            this.decryptor.init(2, (Key)secret, this.IV_PARAMETER_SPEC);
        }
        catch (InvalidKeyException e) {
            SecretKeySpec shorterSecret = new SecretKeySpec(Arrays.copyOfRange(tmp.getEncoded(), 0, tmp.getEncoded().length / 2), this.algorithm);
            this.encryptor.init(1, (Key)shorterSecret, this.IV_PARAMETER_SPEC);
            this.decryptor.init(2, (Key)shorterSecret, this.IV_PARAMETER_SPEC);
        }
    }

    public /* synthetic */ AESCipher(ContextInfo contextInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            contextInfo = KakaoSdk.INSTANCE.getApplicationContextInfo();
        }
        this(contextInfo);
    }

    public AESCipher() {
        this(null, 1, null);
    }
}

