/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.common.util;

import android.content.SharedPreferences;
import com.kakao.sdk.common.util.PersistentKVStore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0001H\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/kakao/sdk/common/util/SharedPrefsWrapper;", "Lcom/kakao/sdk/common/util/PersistentKVStore;", "appCache", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "getAppCache", "()Landroid/content/SharedPreferences;", "editor", "Landroid/content/SharedPreferences$Editor;", "apply", "commit", "getLong", "", "key", "", "fallbackValue", "getString", "putLong", "value", "putString", "remove", "common_release"})
public final class SharedPrefsWrapper
implements PersistentKVStore {
    private final SharedPreferences.Editor editor;
    @NotNull
    private final SharedPreferences appCache;

    @Override
    @NotNull
    public PersistentKVStore remove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.editor.remove(key);
        return this;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String fallbackValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.appCache.getString(key, fallbackValue);
    }

    @Override
    public long getLong(@NotNull String key, long fallbackValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.appCache.getLong(key, fallbackValue);
    }

    @Override
    @NotNull
    public PersistentKVStore putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.editor.putString(key, value);
        return this;
    }

    @Override
    @NotNull
    public PersistentKVStore putLong(@NotNull String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.editor.putLong(key, value);
        return this;
    }

    @Override
    @NotNull
    public PersistentKVStore commit() {
        this.editor.commit();
        return this;
    }

    @Override
    @NotNull
    public PersistentKVStore apply() {
        this.editor.apply();
        return this;
    }

    @NotNull
    public final SharedPreferences getAppCache() {
        return this.appCache;
    }

    public SharedPrefsWrapper(@NotNull SharedPreferences appCache) {
        Intrinsics.checkParameterIsNotNull((Object)appCache, (String)"appCache");
        this.appCache = appCache;
        SharedPreferences.Editor editor = this.appCache.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"appCache.edit()");
        this.editor = editor;
    }
}

