/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.common.model;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.JsonObject;
import com.kakao.sdk.common.KakaoSdk;
import com.kakao.sdk.common.model.ApplicationInfo;
import com.kakao.sdk.common.model.ContextInfo;
import com.kakao.sdk.common.util.Utility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/kakao/sdk/common/model/ApplicationContextInfo;", "Lcom/kakao/sdk/common/model/ApplicationInfo;", "Lcom/kakao/sdk/common/model/ContextInfo;", "context", "Landroid/content/Context;", "appKey", "", "sdkType", "Lcom/kakao/sdk/common/KakaoSdk$Type;", "(Landroid/content/Context;Ljava/lang/String;Lcom/kakao/sdk/common/KakaoSdk$Type;)V", "getAppKey", "()Ljava/lang/String;", "appVer", "getAppVer", "applicationContext", "getApplicationContext", "()Landroid/content/Context;", "extras", "Lcom/google/gson/JsonObject;", "getExtras", "()Lcom/google/gson/JsonObject;", "kaHeader", "getKaHeader", "mAppVer", "mApplicationContext", "mClientId", "mExtras", "mKaHeader", "mKeyHash", "mSalt", "", "mSharedPreferences", "Landroid/content/SharedPreferences;", "salt", "getSalt", "()[B", "sharedPreferences", "getSharedPreferences", "()Landroid/content/SharedPreferences;", "signingKeyHash", "getSigningKeyHash", "common_release"})
public final class ApplicationContextInfo
implements ApplicationInfo,
ContextInfo {
    private final String mClientId;
    private final String mKaHeader;
    private final String mKeyHash;
    private final JsonObject mExtras;
    private final SharedPreferences mSharedPreferences;
    private final String mAppVer;
    private final byte[] mSalt;
    private final Context mApplicationContext;

    @Override
    @NotNull
    public String getAppKey() {
        return this.mClientId;
    }

    @Override
    @NotNull
    public String getKaHeader() {
        return this.mKaHeader;
    }

    @Override
    @NotNull
    public String getSigningKeyHash() {
        return this.mKeyHash;
    }

    @Override
    @NotNull
    public JsonObject getExtras() {
        return this.mExtras;
    }

    @Override
    @NotNull
    public String getAppVer() {
        return this.mAppVer;
    }

    @Override
    @NotNull
    public byte[] getSalt() {
        return this.mSalt;
    }

    @NotNull
    public final SharedPreferences getSharedPreferences() {
        return this.mSharedPreferences;
    }

    @NotNull
    public final Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public ApplicationContextInfo(@NotNull Context context, @NotNull String appKey, @NotNull KakaoSdk.Type sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sdkType), (String)"sdkType");
        this.mClientId = appKey;
        this.mKaHeader = Utility.INSTANCE.getKAHeader(context, sdkType);
        this.mKeyHash = Utility.INSTANCE.getKeyHash(context);
        this.mExtras = Utility.INSTANCE.getExtras(context, sdkType);
        SharedPreferences sharedPreferences = context.getSharedPreferences(appKey, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ey, Context.MODE_PRIVATE)");
        this.mSharedPreferences = sharedPreferences;
        String string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.packageManager.g\u2026ckageName, 0).versionName");
        this.mAppVer = string;
        this.mSalt = Utility.INSTANCE.androidId(context);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this.mApplicationContext = context2;
    }
}

