/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.common.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import com.kakao.sdk.common.util.SdkLog;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/kakao/sdk/common/util/KakaoCustomTabsClient;", "", "()V", "chromePackageNames", "", "", "[Ljava/lang/String;", "isPackageNameChrome", "", "packageName", "open", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "openWithDefault", "Landroid/content/ServiceConnection;", "resolveCustomTabsPackage", "common_release"})
public final class KakaoCustomTabsClient {
    private static final String[] chromePackageNames;
    public static final KakaoCustomTabsClient INSTANCE;

    @Nullable
    public final ServiceConnection openWithDefault(@NotNull Context context, @NotNull Uri uri) throws UnsupportedOperationException {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string2 = this.resolveCustomTabsPackage(context, uri);
        if (string2 == null) {
            throw (Throwable)new UnsupportedOperationException();
        }
        String packageName = string2;
        SdkLog.Companion.d("Choosing " + packageName + " as custom tabs browser");
        CustomTabsServiceConnection connection2 = new CustomTabsServiceConnection(uri, packageName, context){
            final /* synthetic */ Uri $uri;
            final /* synthetic */ String $packageName;
            final /* synthetic */ Context $context;

            public void onCustomTabsServiceConnected(@Nullable ComponentName name, @Nullable CustomTabsClient client) {
                CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder().enableUrlBarHiding().setShowTitle(true);
                CustomTabsIntent customTabsIntent = builder.build();
                Intent intent = customTabsIntent.intent;
                Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"customTabsIntent.intent");
                intent.setData(this.$uri);
                customTabsIntent.intent.setPackage(this.$packageName);
                this.$context.startActivity(customTabsIntent.intent);
            }

            public void onServiceDisconnected(@Nullable ComponentName name) {
                SdkLog.Companion.d("onServiceDisconnected: " + name);
            }
            {
                this.$uri = $captured_local_variable$0;
                this.$packageName = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
            }
        };
        boolean bound = CustomTabsClient.bindCustomTabsService((Context)context, (String)packageName, (CustomTabsServiceConnection)connection2);
        return bound ? (ServiceConnection)connection2 : null;
    }

    public final void open(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        new CustomTabsIntent.Builder().enableUrlBarHiding().setShowTitle(true).build().launchUrl(context, uri);
    }

    private final String resolveCustomTabsPackage(Context context, Uri uri) {
        String packageName = null;
        String chromePackage = null;
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        Intent intent2 = new Intent().setAction("android.support.customtabs.action.CustomTabsService");
        Intrinsics.checkExpressionValueIsNotNull((Object)intent2, (String)"Intent().setAction(Custo\u2026N_CUSTOM_TABS_CONNECTION)");
        Intent serviceIntent = intent2;
        List serviceInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        for (ResolveInfo info : serviceInfos) {
            if (chromePackage == null) {
                String string2 = info.serviceInfo.packageName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.serviceInfo.packageName");
                if (this.isPackageNameChrome(string2)) {
                    chromePackage = info.serviceInfo.packageName;
                }
            }
            if (!Intrinsics.areEqual((Object)info.serviceInfo.packageName, (Object)resolveInfo.activityInfo.packageName)) continue;
            packageName = resolveInfo.activityInfo.packageName;
            break;
        }
        if (packageName == null && chromePackage != null) {
            packageName = chromePackage;
        }
        return packageName;
    }

    private final boolean isPackageNameChrome(String packageName) {
        return ArraysKt.contains((Object[])chromePackageNames, (Object)packageName);
    }

    private KakaoCustomTabsClient() {
    }

    static {
        KakaoCustomTabsClient kakaoCustomTabsClient;
        INSTANCE = kakaoCustomTabsClient = new KakaoCustomTabsClient();
        chromePackageNames = new String[]{"com.android.chrome", "com.chrome.beta", "com.chrome.dev"};
    }
}

