/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.common.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.provider.Settings;
import android.util.Base64;
import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.kakao.sdk.common.KakaoSdk;
import com.kakao.sdk.common.util.KakaoJson;
import com.kakao.sdk.common.util.Utility$WhenMappings;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\bJ\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\b\u00a8\u0006\u001e"}, d2={"Lcom/kakao/sdk/common/util/Utility;", "", "()V", "androidId", "", "context", "Landroid/content/Context;", "buildQuery", "", "params", "", "getExtras", "Lcom/google/gson/JsonObject;", "sdkType", "Lcom/kakao/sdk/common/KakaoSdk$Type;", "getJson", "path", "getJsonArray", "Lcom/google/gson/JsonArray;", "getJsonObject", "getKAHeader", "getKeyHash", "getKeyHashDeprecated", "getMetadata", "key", "hasAndNotNull", "", "jsonObject", "parseQuery", "queries", "common_release"})
public final class Utility {
    public static final Utility INSTANCE;

    @TargetApi(value=28)
    @NotNull
    public final String getKeyHash(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getKeyHashDeprecated(context);
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    @NotNull
    public final String getKeyHashDeprecated(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
        Signature[] signatureArray = packageInfo.signatures;
        int n = signatureArray.length;
        int n2 = 0;
        if (n2 < n) {
            Signature signature = signatureArray[n2];
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(signature.toByteArray());
            String string = Base64.encodeToString((byte[])md.digest(), (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.encodeToString(md.digest(), Base64.NO_WRAP)");
            return string;
        }
        throw (Throwable)new IllegalStateException();
    }

    @NotNull
    public final String getKAHeader(@NotNull Context context, @NotNull KakaoSdk.Type sdkType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sdkType), (String)"sdkType");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%s/%s %s/%s %s/android-%s %s/%s-%s %s/%s %s/%s %s/%s %s/%s";
        Object[] objectArray = new Object[17];
        objectArray[0] = "sdk";
        objectArray[1] = "2.3.0";
        objectArray[2] = "sdk_type";
        switch (Utility$WhenMappings.$EnumSwitchMapping$0[sdkType.ordinal()]) {
            case 1: {
                string = "rx-kotlin";
                break;
            }
            default: {
                string = "kotlin";
            }
        }
        objectArray[3] = string;
        objectArray[4] = "os";
        objectArray[5] = Build.VERSION.SDK_INT;
        objectArray[6] = "lang";
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        String string3 = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Locale.getDefault().language");
        CharSequence charSequence = string3;
        int n = 7;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        boolean bl = false;
        String string4 = charSequence;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String string6 = string5;
        objectArray2[n] = string6;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.getDefault()");
        String string7 = locale2.getCountry();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"Locale.getDefault().country");
        charSequence = string7;
        n = 8;
        objectArray2 = objectArray3;
        bl = false;
        String string8 = charSequence;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toUpperCase()");
        string6 = string9;
        objectArray2[n] = string6;
        Object[] objectArray4 = objectArray3;
        objectArray3[9] = "origin";
        objectArray4[10] = this.getKeyHash(context);
        objectArray4[11] = "device";
        String string10 = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Build.MODEL");
        charSequence = string10;
        String string11 = "\\s";
        n = 12;
        objectArray2 = objectArray4;
        objectArray3 = objectArray4;
        boolean bl2 = false;
        string11 = string6 = new Regex(string11);
        String string12 = "-";
        boolean bl3 = false;
        string6 = string11.replace(charSequence, string12);
        charSequence = string6;
        boolean bl4 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string13 = ((String)charSequence2).toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).toUpperCase()");
        string6 = string13;
        objectArray2[n] = string6;
        Object[] objectArray5 = objectArray3;
        objectArray3[13] = "android_pkg";
        objectArray5[14] = context.getPackageName();
        objectArray5[15] = "app_ver";
        objectArray5[16] = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        charSequence = objectArray5;
        bl4 = false;
        CharSequence charSequence3 = charSequence;
        String string14 = String.format(string2, Arrays.copyOf(charSequence3, ((CharSequence)charSequence3).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"java.lang.String.format(format, *args)");
        return string14;
    }

    @NotNull
    public final JsonObject getExtras(@NotNull Context context, @NotNull KakaoSdk.Type sdkType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sdkType), (String)"sdkType");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("appPkg", context.getPackageName());
        jsonObject.addProperty("keyHash", this.getKeyHash(context));
        jsonObject.addProperty("KA", this.getKAHeader(context, sdkType));
        return jsonObject;
    }

    @Nullable
    public final String getMetadata(@NotNull Context context, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"context.packageManager.g\u2026r.GET_META_DATA\n        )");
        ApplicationInfo ai = applicationInfo;
        return ai.metaData.getString(key);
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final byte[] androidId(@NotNull Context context) throws NoSuchAlgorithmException {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            String androidId;
            String string = androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"androidId");
            CharSequence charSequence = string;
            String string2 = "[0\\s]";
            boolean bl = false;
            string2 = new Regex(string2);
            Object object = "";
            boolean bl2 = false;
            String stripped = string2.replace(charSequence, (String)object);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.reset();
            string2 = "SDK-" + stripped;
            MessageDigest messageDigest = md;
            object = Charsets.UTF_8;
            bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray2;
            messageDigest.update(byArray3);
            byte[] byArray4 = md.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"md.digest()");
            byArray = byArray4;
        }
        catch (Exception e) {
            String string = "xxxx" + Build.PRODUCT + "a23456789012345bcdefg";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray5 = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray5, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = byArray5;
        }
        return byArray;
    }

    @NotNull
    public final Map<String, String> parseQuery(@Nullable String queries) {
        Iterable $this$filterTo$iv$iv;
        List list;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (queries == null) {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)queries, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            list = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            collection.add(list);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            list = new Pair(it.get(0), it.get(1));
            collection.add(list);
        }
        List kvList = (List)destination$iv$iv;
        $i$f$map = false;
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = kvList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Object object = pair.getFirst();
            String string = URLDecoder.decode((String)pair.getSecond(), "UTF-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLDecoder.decode(pair.second, \"UTF-8\")");
            map.put(object, string);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildQuery(@Nullable Map<String, String> params) {
        void $this$mapTo$iv$iv;
        if (params == null || params.isEmpty()) {
            return "";
        }
        Map<String, String> $this$map$iv = params;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        void var7_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_14 = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)var13_14.getKey();
            var13_14 = $dstr$k$v;
            bl3 = false;
            String v = (String)var13_14.getValue();
            String string = k + '=' + v;
            collection.add(string);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s;
            String $i$f$mapTo2 = (String)iterator$iv.next();
            String acc = (String)accumulator$iv;
            boolean bl4 = false;
            accumulator$iv = acc + '&' + (String)s;
        }
        return (String)accumulator$iv;
    }

    @NotNull
    public final String getJson(@NotNull String path) {
        URL uri;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw (Throwable)new NullPointerException();
        }
        ClassLoader classLoader2 = classLoader;
        URL uRL = uri = classLoader2.getResource(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"uri");
        File file = new File(uRL.getPath());
        byte[] byArray = FilesKt.readBytes((File)file);
        boolean bl = false;
        return new String(byArray, Charsets.UTF_8);
    }

    @NotNull
    public final JsonObject getJsonObject(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (JsonObject)KakaoJson.INSTANCE.fromJson(this.getJson(path), (Type)((Object)JsonObject.class));
    }

    @NotNull
    public final JsonArray getJsonArray(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (JsonArray)KakaoJson.INSTANCE.fromJson(this.getJson(path), (Type)((Object)JsonArray.class));
    }

    public final boolean hasAndNotNull(@NotNull JsonObject jsonObject, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return jsonObject.has(key) && !(jsonObject.get(key) instanceof JsonNull);
    }

    private Utility() {
    }

    static {
        Utility utility;
        INSTANCE = utility = new Utility();
    }
}

