/*
  Copyright 2020 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.partner.user

import com.kakao.sdk.partner.Constants
import com.kakao.sdk.partner.user.model.PartnerUser
import io.reactivex.Completable
import io.reactivex.Single
import retrofit2.http.*

/**
 * @suppress
 */
interface RxPartnerUserApi {
    @GET(com.kakao.sdk.user.Constants.V2_ME_PATH)
    fun me(
        @Query(com.kakao.sdk.user.Constants.PROPERTYKEYS) properties: String? = null,
        @Query(com.kakao.sdk.user.Constants.SECURE_RESOURCE) secureResource: Boolean = true
    ): Single<PartnerUser>

    @POST(Constants.V1_SIGNUP_PATH)
    @FormUrlEncoded
    fun signup(
        @Field(com.kakao.sdk.user.Constants.PROPERTIES) properties: Map<String, String>? = null
    ): Completable
}