/*
  Copyright 2020 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.partner.user

import com.kakao.sdk.auth.network.rxKapiWithOAuth
import com.kakao.sdk.common.util.KakaoJson
import com.kakao.sdk.common.network.ApiFactory
import com.kakao.sdk.common.network.RxApiInterceptor
import com.kakao.sdk.partner.user.model.PartnerUser
import com.kakao.sdk.user.RxUserApiClient
import io.reactivex.Completable
import io.reactivex.Single

// TODO: Java에서 호출 가능하게

/**
 * @suppress
 */
val RxUserApiClient.partnerApi: RxPartnerUserApi
    get() = ApiFactory.rxKapiWithOAuth.create(RxPartnerUserApi::class.java)


/**
 * 파트너용 /v2/user/me API 를 호출합니다. 사용자에 대한 다양한 정보를 얻을 수 있습니다.
 *
 * @since 2.0.0
 */
@JvmOverloads
fun RxUserApiClient.meForPartner(
    propertyKeys: List<String>? = null,
    secureReSource: Boolean = true
): Single<PartnerUser> =
    partnerApi.me(
        if (propertyKeys == null) null else KakaoJson.toJson(propertyKeys),
        secureReSource
    )
        .compose(RxApiInterceptor.handleApiError())
        .compose(apiInterceptor.handleApiError())

/**
 * 앱 연결 상태가 **PREREGISTER** 상태의 사용자에 대하여 앱 연결 요청을 합니다. **자동연결** 설정을 비활성화한 앱에서 사용합니다.
 *
 * @since 2.0.0
 */
@JvmOverloads
fun RxUserApiClient.signup(properties: Map<String, String>? = null): Completable =
    partnerApi.signup(properties)
        .compose(RxApiInterceptor.handleCompletableError())
        .compose(apiInterceptor.handleCompletableError())
