/*
  Copyright 2020 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.story

import com.kakao.sdk.common.json.MapToQuery
import com.kakao.sdk.story.model.*
import okhttp3.MultipartBody
import retrofit2.Call
import retrofit2.http.*

/**
 * @suppress
 */
interface StoryApi {
    @GET(Constants.IS_STORY_USER_PATH)
    fun isStoryUser(): Call<StoryUserResult>

    @GET(Constants.STORY_PROFILE_PATH)
    fun profile(@Query(Constants.SECURE_RESOURCE) secureResource: Boolean? = true): Call<StoryProfile>

    @GET(Constants.GET_STORY_PATH)
    fun story(@Query(Constants.ID) id: String): Call<Story>

    @GET(Constants.GET_STORIES_PATH)
    fun stories(@Query(Constants.LAST_ID) lastId: String? = null): Call<List<Story>>

    @FormUrlEncoded
    @POST(Constants.POST_NOTE_PATH)
    fun postNote(
        @Field(Constants.CONTENT) content: String,
        @Field(Constants.PERMISSION) permission: Story.Permission = Story.Permission.PUBLIC,
        @Field(Constants.ENABLE_SHARE) enableShare: Boolean = true,
        @MapToQuery @Field(Constants.ANDROID_EXEC_PARAM) androidExecParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.IOS_EXEC_PARAM) iosExecParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.ANDROID_MARKET_PARAM) androidMarketParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.IOS_MARKET_PARAM) iosMarketParams: Map<String, String>? = null
    ): Call<StoryPostResult>

    @FormUrlEncoded
    @POST(Constants.POST_PHOTO_PATH)
    fun postPhoto(
        @Field(Constants.IMAGE_URL_LIST) images: String,
        @Field(Constants.CONTENT) content: String,
        @Field(Constants.PERMISSION) permission: Story.Permission = Story.Permission.PUBLIC,
        @Field(Constants.ENABLE_SHARE) enableShare: Boolean = true,
        @MapToQuery @Field(Constants.ANDROID_EXEC_PARAM) androidExecParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.IOS_EXEC_PARAM) iosExecParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.ANDROID_MARKET_PARAM) androidMarketParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.IOS_MARKET_PARAM) iosMarketParams: Map<String, String>? = null
    ): Call<StoryPostResult>

    @FormUrlEncoded
    @POST(Constants.POST_LINK_PATH)
    fun postLink(
        @Field(Constants.LINK_INFO) linkInfo: LinkInfo,
        @Field(Constants.CONTENT) content: String,
        @Field(Constants.PERMISSION) permission: Story.Permission = Story.Permission.PUBLIC,
        @Field(Constants.ENABLE_SHARE) enableShare: Boolean = true,
        @MapToQuery @Field(Constants.ANDROID_EXEC_PARAM) androidExecParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.IOS_EXEC_PARAM) iosExecParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.ANDROID_MARKET_PARAM) androidMarketParams: Map<String, String>? = null,
        @MapToQuery @Field(Constants.IOS_MARKET_PARAM) iosMarketParams: Map<String, String>? = null
    ): Call<StoryPostResult>

    @DELETE(Constants.DELETE_STORY_PATH)
    fun delete(@Query(Constants.ID) id: String): Call<Unit>

    @GET(Constants.SCRAP_LINK_PATH)
    fun linkInfo(@Query(Constants.URL) url: String): Call<LinkInfo>

    @Multipart
    @POST(Constants.SCRAP_IMAGES_PATH)
    fun upload(@Part images: List<MultipartBody.Part>): Call<List<String>>
}