/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.auth;

import com.kakao.sdk.auth.AuthApi;
import com.kakao.sdk.auth.AuthApiManager;
import com.kakao.sdk.auth.TokenManagerProvider;
import com.kakao.sdk.auth.model.AccessTokenResponse;
import com.kakao.sdk.auth.model.AgtResponse;
import com.kakao.sdk.auth.model.CertTokenInfo;
import com.kakao.sdk.auth.model.CertType;
import com.kakao.sdk.auth.model.IdentifyItem;
import com.kakao.sdk.auth.model.OAuthToken;
import com.kakao.sdk.auth.model.PrepareResponse;
import com.kakao.sdk.auth.network.ApiFactoryKt;
import com.kakao.sdk.common.KakaoSdk;
import com.kakao.sdk.common.model.ApplicationInfo;
import com.kakao.sdk.common.model.ApprovalType;
import com.kakao.sdk.common.model.AuthError;
import com.kakao.sdk.common.model.AuthErrorCause;
import com.kakao.sdk.common.model.AuthErrorResponse;
import com.kakao.sdk.common.model.ClientError;
import com.kakao.sdk.common.model.ClientErrorCause;
import com.kakao.sdk.common.model.ContextInfo;
import com.kakao.sdk.common.util.KakaoJson;
import com.kakao.sdk.network.ApiFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJI\u0010\u0015\u001a\u00020\u00162:\u0010\u0017\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0015\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00160\u0018H\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J]\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00192\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00192:\u0010\u0017\u001a6\u0012\u0015\u0012\u0013\u0018\u00010%\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(&\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00160\u0018H\u0000\u00a2\u0006\u0002\b'J]\u0010(\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00192\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00192:\u0010\u0017\u001a6\u0012\u0015\u0012\u0013\u0018\u00010)\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(*\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00160\u0018H\u0000\u00a2\u0006\u0002\b+J\u0087\u0001\u0010,\u001a\u00020\u00162\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00192\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u00103\u001a\u0002042:\u0010\u0017\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(5\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00160\u0018H\u0000\u00a2\u0006\u0002\b6J\u0017\u00107\u001a\u00020%2\b\b\u0002\u00108\u001a\u00020%H\u0000\u00a2\u0006\u0002\b9JS\u00107\u001a\u00020\u00162\b\b\u0002\u00108\u001a\u00020%2:\u0010\u0017\u001a6\u0012\u0015\u0012\u0013\u0018\u00010%\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(&\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00160\u0018H\u0001\u00a2\u0006\u0002\b9R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006;"}, d2={"Lcom/kakao/sdk/auth/AuthApiManager;", "", "authApi", "Lcom/kakao/sdk/auth/AuthApi;", "tokenManagerProvider", "Lcom/kakao/sdk/auth/TokenManagerProvider;", "applicationInfo", "Lcom/kakao/sdk/common/model/ApplicationInfo;", "contextInfo", "Lcom/kakao/sdk/common/model/ContextInfo;", "approvalType", "Lcom/kakao/sdk/common/model/ApprovalType;", "(Lcom/kakao/sdk/auth/AuthApi;Lcom/kakao/sdk/auth/TokenManagerProvider;Lcom/kakao/sdk/common/model/ApplicationInfo;Lcom/kakao/sdk/common/model/ContextInfo;Lcom/kakao/sdk/common/model/ApprovalType;)V", "getApplicationInfo", "()Lcom/kakao/sdk/common/model/ApplicationInfo;", "getApprovalType", "()Lcom/kakao/sdk/common/model/ApprovalType;", "getContextInfo", "()Lcom/kakao/sdk/common/model/ContextInfo;", "getTokenManagerProvider", "()Lcom/kakao/sdk/auth/TokenManagerProvider;", "agt", "", "callback", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "", "error", "agt$auth_release", "hasToken", "", "hasToken$auth_release", "issueAccessToken", "code", "codeVerifier", "Lcom/kakao/sdk/auth/model/OAuthToken;", "token", "issueAccessToken$auth_release", "issueAccessTokenWithCert", "Lcom/kakao/sdk/auth/model/CertTokenInfo;", "certTokenInfo", "issueAccessTokenWithCert$auth_release", "prepare", "settleId", "identifyItems", "", "Lcom/kakao/sdk/auth/model/IdentifyItem;", "signData", "txId", "certType", "Lcom/kakao/sdk/auth/model/CertType;", "kauthTxId", "prepare$auth_release", "refreshToken", "oldToken", "refreshToken$auth_release", "Companion", "auth_release"})
public final class AuthApiManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthApi authApi;
    @NotNull
    private final TokenManagerProvider tokenManagerProvider;
    @NotNull
    private final ApplicationInfo applicationInfo;
    @NotNull
    private final ContextInfo contextInfo;
    @NotNull
    private final ApprovalType approvalType;
    @NotNull
    private static final Lazy<AuthApiManager> instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);

    public AuthApiManager(@NotNull AuthApi authApi, @NotNull TokenManagerProvider tokenManagerProvider, @NotNull ApplicationInfo applicationInfo, @NotNull ContextInfo contextInfo, @NotNull ApprovalType approvalType) {
        Intrinsics.checkNotNullParameter((Object)authApi, (String)"authApi");
        Intrinsics.checkNotNullParameter((Object)tokenManagerProvider, (String)"tokenManagerProvider");
        Intrinsics.checkNotNullParameter((Object)applicationInfo, (String)"applicationInfo");
        Intrinsics.checkNotNullParameter((Object)contextInfo, (String)"contextInfo");
        Intrinsics.checkNotNullParameter((Object)approvalType, (String)"approvalType");
        this.authApi = authApi;
        this.tokenManagerProvider = tokenManagerProvider;
        this.applicationInfo = applicationInfo;
        this.contextInfo = contextInfo;
        this.approvalType = approvalType;
    }

    public /* synthetic */ AuthApiManager(AuthApi authApi, TokenManagerProvider tokenManagerProvider, ApplicationInfo applicationInfo, ContextInfo contextInfo, ApprovalType approvalType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object object = ApiFactoryKt.getKauth(ApiFactory.INSTANCE).create(AuthApi.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApiFactory.kauth.create(AuthApi::class.java)");
            authApi = (AuthApi)object;
        }
        if ((n & 2) != 0) {
            tokenManagerProvider = TokenManagerProvider.Companion.getInstance();
        }
        if ((n & 4) != 0) {
            applicationInfo = (ApplicationInfo)KakaoSdk.INSTANCE.getApplicationContextInfo();
        }
        if ((n & 8) != 0) {
            contextInfo = (ContextInfo)KakaoSdk.INSTANCE.getApplicationContextInfo();
        }
        if ((n & 0x10) != 0) {
            approvalType = KakaoSdk.INSTANCE.getApprovalType();
        }
        this(authApi, tokenManagerProvider, applicationInfo, contextInfo, approvalType);
    }

    @NotNull
    public final TokenManagerProvider getTokenManagerProvider() {
        return this.tokenManagerProvider;
    }

    @NotNull
    public final ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @NotNull
    public final ContextInfo getContextInfo() {
        return this.contextInfo;
    }

    @NotNull
    public final ApprovalType getApprovalType() {
        return this.approvalType;
    }

    public final boolean hasToken$auth_release() {
        return this.tokenManagerProvider.getManager().getToken() != null;
    }

    public final void issueAccessToken$auth_release(@NotNull String code, @Nullable String codeVerifier, @NotNull Function2<? super OAuthToken, ? super Throwable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        AuthApi.DefaultImpls.issueAccessToken$default(this.authApi, this.applicationInfo.getAppKey(), this.contextInfo.getSigningKeyHash(), code, this.applicationInfo.getRedirectUri(), codeVerifier, this.approvalType.getValue(), null, 64, null).enqueue((Callback)new Callback<AccessTokenResponse>(callback, this){
            final /* synthetic */ Function2<OAuthToken, Throwable, Unit> $callback;
            final /* synthetic */ AuthApiManager this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Call<AccessTokenResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.invoke(null, (Object)t);
            }

            public void onResponse(@NotNull Call<AccessTokenResponse> call, @NotNull Response<AccessTokenResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.body();
                    if (accessTokenResponse != null) {
                        AccessTokenResponse accessTokenResponse2 = accessTokenResponse;
                        AuthApiManager authApiManager = this.this$0;
                        Function2<OAuthToken, Throwable, Unit> function2 = this.$callback;
                        AccessTokenResponse it = accessTokenResponse2;
                        boolean bl = false;
                        OAuthToken token = OAuthToken.Companion.fromResponse$default(OAuthToken.Companion, it, null, 2, null);
                        authApiManager.getTokenManagerProvider().getManager().setToken(token);
                        function2.invoke((Object)token, null);
                        return;
                    }
                    this.$callback.invoke(null, (Object)new ClientError(ClientErrorCause.Unknown, "No body"));
                } else {
                    this.$callback.invoke(null, (Object)AuthApiManager.Companion.translateError((Throwable)new HttpException(response)));
                }
            }
        });
    }

    public static /* synthetic */ void issueAccessToken$auth_release$default(AuthApiManager authApiManager, String string, String string2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        authApiManager.issueAccessToken$auth_release(string, string2, (Function2<? super OAuthToken, ? super Throwable, Unit>)function2);
    }

    public final void issueAccessTokenWithCert$auth_release(@NotNull String code, @Nullable String codeVerifier, @NotNull Function2<? super CertTokenInfo, ? super Throwable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        AuthApi.DefaultImpls.issueAccessToken$default(this.authApi, this.applicationInfo.getAppKey(), this.contextInfo.getSigningKeyHash(), code, this.applicationInfo.getRedirectUri(), codeVerifier, this.approvalType.getValue(), null, 64, null).enqueue((Callback)new Callback<AccessTokenResponse>(callback, this){
            final /* synthetic */ Function2<CertTokenInfo, Throwable, Unit> $callback;
            final /* synthetic */ AuthApiManager this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Call<AccessTokenResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.invoke(null, (Object)t);
            }

            public void onResponse(@NotNull Call<AccessTokenResponse> call, @NotNull Response<AccessTokenResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.body();
                    if (accessTokenResponse != null) {
                        AccessTokenResponse accessTokenResponse2 = accessTokenResponse;
                        Function2<CertTokenInfo, Throwable, Unit> function2 = this.$callback;
                        AuthApiManager authApiManager = this.this$0;
                        AccessTokenResponse it = accessTokenResponse2;
                        boolean bl = false;
                        OAuthToken token = OAuthToken.Companion.fromResponse$default(OAuthToken.Companion, it, null, 2, null);
                        String txId = it.getTxId();
                        if (txId == null) {
                            function2.invoke(null, (Object)new ClientError(ClientErrorCause.Unknown, "txId is null"));
                            return;
                        }
                        authApiManager.getTokenManagerProvider().getManager().setToken(token);
                        function2.invoke((Object)new CertTokenInfo(token, txId), null);
                        return;
                    }
                    this.$callback.invoke(null, (Object)new ClientError(ClientErrorCause.Unknown, "No body"));
                } else {
                    this.$callback.invoke(null, (Object)AuthApiManager.Companion.translateError((Throwable)new HttpException(response)));
                }
            }
        });
    }

    public static /* synthetic */ void issueAccessTokenWithCert$auth_release$default(AuthApiManager authApiManager, String string, String string2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        authApiManager.issueAccessTokenWithCert$auth_release(string, string2, (Function2<? super CertTokenInfo, ? super Throwable, Unit>)function2);
    }

    @JvmOverloads
    public final void refreshToken$auth_release(@NotNull OAuthToken oldToken, @NotNull Function2<? super OAuthToken, ? super Throwable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)oldToken, (String)"oldToken");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        AuthApi.DefaultImpls.refreshToken$default(this.authApi, this.applicationInfo.getAppKey(), this.contextInfo.getSigningKeyHash(), oldToken.getRefreshToken(), this.approvalType.getValue(), null, 16, null).enqueue((Callback)new Callback<AccessTokenResponse>(callback, oldToken, this){
            final /* synthetic */ Function2<OAuthToken, Throwable, Unit> $callback;
            final /* synthetic */ OAuthToken $oldToken;
            final /* synthetic */ AuthApiManager this$0;
            {
                this.$callback = $callback;
                this.$oldToken = $oldToken;
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Call<AccessTokenResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.invoke(null, (Object)t);
            }

            public void onResponse(@NotNull Call<AccessTokenResponse> call, @NotNull Response<AccessTokenResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.body();
                    if (accessTokenResponse != null) {
                        AccessTokenResponse accessTokenResponse2 = accessTokenResponse;
                        OAuthToken oAuthToken = this.$oldToken;
                        AuthApiManager authApiManager = this.this$0;
                        Function2<OAuthToken, Throwable, Unit> function2 = this.$callback;
                        AccessTokenResponse it = accessTokenResponse2;
                        boolean bl = false;
                        OAuthToken token = OAuthToken.Companion.fromResponse(it, oAuthToken);
                        authApiManager.getTokenManagerProvider().getManager().setToken(token);
                        function2.invoke((Object)token, null);
                        return;
                    }
                    this.$callback.invoke(null, (Object)new ClientError(ClientErrorCause.Unknown, "No body"));
                } else {
                    this.$callback.invoke(null, (Object)AuthApiManager.Companion.translateError((Throwable)new HttpException(response)));
                }
            }
        });
    }

    public static /* synthetic */ void refreshToken$auth_release$default(AuthApiManager authApiManager, OAuthToken oAuthToken, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            OAuthToken oAuthToken2 = authApiManager.tokenManagerProvider.getManager().getToken();
            if (oAuthToken2 == null) {
                throw new ClientError(ClientErrorCause.TokenNotFound, "Refresh token not found. You must login first.");
            }
            oAuthToken = oAuthToken2;
        }
        authApiManager.refreshToken$auth_release(oAuthToken, (Function2<? super OAuthToken, ? super Throwable, Unit>)function2);
    }

    public final void agt$auth_release(@NotNull Function2<? super String, ? super Throwable, Unit> callback) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            Object object = this.tokenManagerProvider.getManager().getToken();
            if (object != null && (object = ((OAuthToken)object).getAccessToken()) != null) {
                Object accessToken = object;
                boolean bl = false;
                this.authApi.agt(this.applicationInfo.getAppKey(), (String)accessToken).enqueue((Callback)new Callback<AgtResponse>(callback){
                    final /* synthetic */ Function2<String, Throwable, Unit> $callback;
                    {
                        this.$callback = $callback;
                    }

                    public void onFailure(@NotNull Call<AgtResponse> call, @NotNull Throwable t) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        this.$callback.invoke(null, (Object)t);
                    }

                    public void onResponse(@NotNull Call<AgtResponse> call, @NotNull Response<AgtResponse> response) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter(response, (String)"response");
                        AgtResponse agtResponse = (AgtResponse)response.body();
                        if (agtResponse != null) {
                            AgtResponse agtResponse2 = agtResponse;
                            Function2<String, Throwable, Unit> function2 = this.$callback;
                            AgtResponse agtResponse3 = agtResponse2;
                            boolean bl = false;
                            function2.invoke((Object)agtResponse3.getAgt(), null);
                            return;
                        }
                        this.$callback.invoke(null, (Object)AuthApiManager.Companion.translateError((Throwable)new HttpException(response)));
                    }
                });
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            callback.invoke(null, (Object)new ClientError(ClientErrorCause.TokenNotFound, "Access token not found. You must login first."));
        }
    }

    @NotNull
    public final OAuthToken refreshToken$auth_release(@NotNull OAuthToken oldToken) {
        Object object;
        block3: {
            Response response;
            block2: {
                Intrinsics.checkNotNullParameter((Object)oldToken, (String)"oldToken");
                response = AuthApi.DefaultImpls.refreshToken$default(this.authApi, this.applicationInfo.getAppKey(), this.contextInfo.getSigningKeyHash(), oldToken.getRefreshToken(), this.approvalType.getValue(), null, 16, null).execute();
                object = (AccessTokenResponse)response.body();
                if (object == null) break block2;
                AccessTokenResponse it = object;
                boolean bl = false;
                OAuthToken oAuthToken = OAuthToken.Companion.fromResponse(it, oldToken);
                object = oAuthToken;
                if (oAuthToken != null) break block3;
            }
            throw Companion.translateError((Throwable)new HttpException(response));
        }
        Object token = object;
        this.tokenManagerProvider.getManager().setToken((OAuthToken)token);
        return token;
    }

    public static /* synthetic */ OAuthToken refreshToken$auth_release$default(AuthApiManager authApiManager, OAuthToken oAuthToken, int n, Object object) {
        if ((n & 1) != 0) {
            OAuthToken oAuthToken2 = authApiManager.tokenManagerProvider.getManager().getToken();
            if (oAuthToken2 == null) {
                throw new ClientError(ClientErrorCause.TokenNotFound, "Refresh token not found. You must login first.");
            }
            oAuthToken = oAuthToken2;
        }
        return authApiManager.refreshToken$auth_release(oAuthToken);
    }

    public final void prepare$auth_release(@Nullable String settleId, @Nullable List<? extends IdentifyItem> identifyItems, @Nullable String signData, @Nullable String txId, @NotNull CertType certType, @NotNull Function2<? super String, ? super Throwable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)certType), (String)"certType");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Collection collection = identifyItems;
        this.authApi.prepare(this.applicationInfo.getAppKey(), settleId, collection == null || collection.isEmpty() ? null : CollectionsKt.joinToString$default((Iterable)identifyItems, (CharSequence)",", null, null, (int)0, null, (Function1)prepare.1.INSTANCE, (int)30, null), signData, txId, certType.getValue()).enqueue((Callback)new Callback<PrepareResponse>(callback){
            final /* synthetic */ Function2<String, Throwable, Unit> $callback;
            {
                this.$callback = $callback;
            }

            public void onFailure(@NotNull Call<PrepareResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.invoke(null, (Object)t);
            }

            public void onResponse(@NotNull Call<PrepareResponse> call, @NotNull Response<PrepareResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    PrepareResponse prepareResponse = (PrepareResponse)response.body();
                    if (prepareResponse != null) {
                        PrepareResponse prepareResponse2 = prepareResponse;
                        Function2<String, Throwable, Unit> function2 = this.$callback;
                        PrepareResponse it = prepareResponse2;
                        boolean bl = false;
                        function2.invoke((Object)it.getKauthTxId(), null);
                        return;
                    }
                    this.$callback.invoke(null, (Object)new ClientError(ClientErrorCause.Unknown, "No body"));
                } else {
                    this.$callback.invoke(null, (Object)AuthApiManager.Companion.translateError((Throwable)new HttpException(response)));
                }
            }
        });
    }

    public static /* synthetic */ void prepare$auth_release$default(AuthApiManager authApiManager, String string, List list, String string2, String string3, CertType certType, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        authApiManager.prepare$auth_release(string, list, string2, string3, certType, (Function2<? super String, ? super Throwable, Unit>)function2);
    }

    @JvmOverloads
    public final void refreshToken$auth_release(@NotNull Function2<? super OAuthToken, ? super Throwable, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        AuthApiManager.refreshToken$auth_release$default(this, null, callback, 1, null);
    }

    public AuthApiManager() {
        this(null, null, null, null, null, 31, null);
    }

    @NotNull
    public static final AuthApiManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/kakao/sdk/auth/AuthApiManager$Companion;", "", "()V", "instance", "Lcom/kakao/sdk/auth/AuthApiManager;", "getInstance$annotations", "getInstance", "()Lcom/kakao/sdk/auth/AuthApiManager;", "instance$delegate", "Lkotlin/Lazy;", "translateError", "", "t", "auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Throwable translateError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            try {
                if (t instanceof HttpException) {
                    Object object;
                    String errorString;
                    Response response = ((HttpException)t).response();
                    String string = errorString = response != null && (response = response.errorBody()) != null ? response.string() : null;
                    Intrinsics.checkNotNull((Object)string);
                    AuthErrorResponse response2 = (AuthErrorResponse)KakaoJson.INSTANCE.fromJson(string, (Type)((Object)AuthErrorResponse.class));
                    try {
                        boolean bl = false;
                        object = Result.constructor-impl((Object)((AuthErrorCause)KakaoJson.INSTANCE.fromJson(response2.getError(), (Type)((Object)AuthErrorCause.class))));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    AuthErrorCause authErrorCause = AuthErrorCause.Unknown;
                    Object cause = Result.isFailure-impl((Object)object) ? authErrorCause : object;
                    return (Throwable)new AuthError(((HttpException)t).code(), cause, response2);
                }
                return t;
            }
            catch (Throwable unexpected) {
                return unexpected;
            }
        }

        @NotNull
        public final AuthApiManager getInstance() {
            Lazy lazy = instance$delegate;
            return (AuthApiManager)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

