/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.auth;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.ResultReceiver;
import androidx.appcompat.app.AppCompatActivity;
import com.kakao.sdk.common.model.ClientError;
import com.kakao.sdk.common.model.ClientErrorCause;
import com.kakao.sdk.common.model.KakaoSdkError;
import com.kakao.sdk.common.util.KakaoCustomTabsClient;
import com.kakao.sdk.common.util.SdkLog;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0014J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0013H\u0014J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/kakao/sdk/auth/CustomTabLauncherActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "customTabsConnection", "Landroid/content/ServiceConnection;", "customTabsOpened", "", "fullUri", "Landroid/net/Uri;", "internalHandler", "Landroid/os/Handler;", "resultReceiver", "Landroid/os/ResultReceiver;", "loadData", "", "intent", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onNewIntent", "onRestoreInstanceState", "onResume", "onSaveInstanceState", "outState", "openBrowserWithoutBinding", "uri", "openChromeCustomTab", "sendError", "exception", "Lcom/kakao/sdk/common/model/KakaoSdkError;", "sendOK", "auth_release"})
@SourceDebugExtension(value={"SMAP\nCustomTabLauncherActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomTabLauncherActivity.kt\ncom/kakao/sdk/auth/CustomTabLauncherActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public class CustomTabLauncherActivity
extends AppCompatActivity {
    private ResultReceiver resultReceiver;
    private Uri fullUri;
    private boolean customTabsOpened;
    @Nullable
    private ServiceConnection customTabsConnection;
    @Nullable
    private Handler internalHandler;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        this.loadData(intent);
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putBoolean("key.customtabs.opened", this.customTabsOpened);
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        this.customTabsOpened = savedInstanceState.getBoolean("key.customtabs.opened", this.customTabsOpened);
    }

    /*
     * WARNING - void declaration
     */
    public void loadData(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            Bundle bundle = intent.getExtras();
            if (bundle != null && (bundle = bundle.getBundle("key.bundle")) != null) {
                Uri uri;
                ResultReceiver resultReceiver2;
                ResultReceiver resultReceiver3;
                Bundle $this$loadData_u24lambda_u240 = bundle;
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    resultReceiver3 = (ResultReceiver)$this$loadData_u24lambda_u240.getParcelable("key.result.receiver", ResultReceiver.class);
                } else {
                    Parcelable parcelable = $this$loadData_u24lambda_u240.getParcelable("key.result.receiver");
                    Intrinsics.checkNotNull((Object)parcelable, (String)"null cannot be cast to non-null type android.os.ResultReceiver");
                    resultReceiver3 = resultReceiver2 = (ResultReceiver)parcelable;
                }
                if (resultReceiver2 == null) {
                    throw new IllegalStateException();
                }
                this.resultReceiver = resultReceiver2;
                if (Build.VERSION.SDK_INT >= 33) {
                    uri = (Uri)$this$loadData_u24lambda_u240.getParcelable("key.full_authorize_uri", Uri.class);
                } else {
                    Parcelable parcelable = $this$loadData_u24lambda_u240.getParcelable("key.full_authorize_uri");
                    Intrinsics.checkNotNull((Object)parcelable, (String)"null cannot be cast to non-null type android.net.Uri");
                    uri = resultReceiver2 = (Uri)parcelable;
                }
                if (resultReceiver2 == null) {
                    throw new IllegalStateException();
                }
                this.fullUri = resultReceiver2;
            }
            this.internalHandler = new Handler(Looper.getMainLooper(), arg_0 -> CustomTabLauncherActivity.loadData$lambda$1(this, arg_0));
        }
        catch (Throwable e) {
            void $this$loadData_u24lambda_u242;
            ClientError clientError;
            SdkLog.Companion.e((Object)e);
            ClientError clientError2 = clientError = new ClientError(ClientErrorCause.Unknown, null, 2, null);
            CustomTabLauncherActivity customTabLauncherActivity = this;
            boolean bl = false;
            $this$loadData_u24lambda_u242.initCause(e);
            customTabLauncherActivity.sendError((KakaoSdkError)clientError);
        }
    }

    protected void onResume() {
        block5: {
            block4: {
                super.onResume();
                if (this.customTabsOpened) break block4;
                this.customTabsOpened = true;
                if (this.fullUri != null) {
                    Uri uri = this.fullUri;
                    if (uri == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"fullUri");
                        uri = null;
                    }
                    this.openChromeCustomTab(uri);
                } else {
                    this.sendError((KakaoSdkError)new ClientError(ClientErrorCause.IllegalState, "url has been not initialized."));
                }
                break block5;
            }
            SdkLog.Companion.i((Object)"trigger delay message");
            Handler handler = this.internalHandler;
            Boolean it = handler != null ? Boolean.valueOf(handler.hasMessages(0)) : null;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)false)) break block5;
            Handler handler2 = this.internalHandler;
            if (handler2 != null) {
                handler2.sendEmptyMessageDelayed(0, 100L);
            }
        }
    }

    protected void onNewIntent(@Nullable Intent intent) {
        super.onNewIntent(intent);
        SdkLog.Companion.i((Object)"onNewIntent");
        this.setIntent(intent);
        Handler handler = this.internalHandler;
        Boolean it = handler != null ? Boolean.valueOf(handler.hasMessages(0)) : null;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)true)) {
            Handler handler2 = this.internalHandler;
            if (handler2 != null) {
                handler2.removeMessages(0);
            }
        }
        this.internalHandler = null;
        Intent intent2 = intent;
        if (intent2 != null && (intent2 = intent2.getData()) != null) {
            Intent it2 = intent2;
            boolean bl2 = false;
            this.sendOK((Uri)it2);
        }
        this.finish();
    }

    protected void onDestroy() {
        block0: {
            super.onDestroy();
            ServiceConnection serviceConnection = this.customTabsConnection;
            if (serviceConnection == null) break block0;
            ServiceConnection it = serviceConnection;
            boolean bl = false;
            this.unbindService(it);
        }
    }

    private final void openChromeCustomTab(Uri uri) {
        SdkLog.Companion.i((Object)("Authorize Uri: " + uri));
        try {
            this.customTabsConnection = KakaoCustomTabsClient.INSTANCE.openWithDefault((Context)this, uri);
            if (this.customTabsConnection == null) {
                SdkLog.Companion.i((Object)"try to open chrome without service binding");
                this.openBrowserWithoutBinding(uri);
            }
        }
        catch (UnsupportedOperationException e) {
            SdkLog.Companion.w((Object)e);
            this.openBrowserWithoutBinding(uri);
        }
    }

    private final void openBrowserWithoutBinding(Uri uri) {
        try {
            KakaoCustomTabsClient.INSTANCE.open((Context)this, uri);
        }
        catch (ActivityNotFoundException e) {
            SdkLog.Companion.w((Object)e);
            this.sendError((KakaoSdkError)new ClientError(ClientErrorCause.NotSupported, "No browser has been installed on a device."));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendError(KakaoSdkError exception) {
        if (this.resultReceiver != null) {
            void $this$sendError_u24lambda_u247;
            Bundle bundle;
            ResultReceiver resultReceiver2 = this.resultReceiver;
            if (resultReceiver2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultReceiver");
                resultReceiver2 = null;
            }
            Bundle bundle2 = bundle = new Bundle();
            int n = 0;
            ResultReceiver resultReceiver3 = resultReceiver2;
            boolean bl = false;
            $this$sendError_u24lambda_u247.putSerializable("key.exception", (Serializable)exception);
            Unit unit = Unit.INSTANCE;
            resultReceiver3.send(n, bundle);
        }
        this.finish();
    }

    /*
     * WARNING - void declaration
     */
    private final void sendOK(Uri uri) {
        if (this.resultReceiver != null) {
            void $this$sendOK_u24lambda_u248;
            Bundle bundle;
            ResultReceiver resultReceiver2 = this.resultReceiver;
            if (resultReceiver2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultReceiver");
                resultReceiver2 = null;
            }
            Bundle bundle2 = bundle = new Bundle();
            int n = -1;
            ResultReceiver resultReceiver3 = resultReceiver2;
            boolean bl = false;
            $this$sendOK_u24lambda_u248.putParcelable("key.url", (Parcelable)uri);
            Unit unit = Unit.INSTANCE;
            resultReceiver3.send(n, bundle);
        }
        this.finish();
    }

    private static final boolean loadData$lambda$1(CustomTabLauncherActivity this$0, Message it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SdkLog.Companion.i((Object)"handle delay message");
        this$0.sendError((KakaoSdkError)new ClientError(ClientErrorCause.Cancelled, null, 2, null));
        return true;
    }
}

