/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.auth;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import com.kakao.sdk.common.model.AuthError;
import com.kakao.sdk.common.model.AuthErrorCause;
import com.kakao.sdk.common.model.AuthErrorResponse;
import com.kakao.sdk.common.model.ClientError;
import com.kakao.sdk.common.model.ClientErrorCause;
import com.kakao.sdk.common.model.KakaoSdkError;
import com.kakao.sdk.common.util.KakaoJson;
import com.kakao.sdk.common.util.SdkLog;
import com.kakao.sdk.v2.auth.R;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/kakao/sdk/auth/TalkAuthCodeActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "APPLICATION_ERROR", "", "getAPPLICATION_ERROR", "()Ljava/lang/String;", "AUTH_CODE_ERROR", "getAUTH_CODE_ERROR", "CLIENT_INFO_ERROR", "getCLIENT_INFO_ERROR", "EXTRA_ERROR_DESCRIPTION", "getEXTRA_ERROR_DESCRIPTION", "EXTRA_ERROR_TYPE", "getEXTRA_ERROR_TYPE", "NOT_SUPPORT_ERROR", "getNOT_SUPPORT_ERROR", "PROTOCOL_ERROR", "getPROTOCOL_ERROR", "UNKNOWN_ERROR", "getUNKNOWN_ERROR", "activityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "resultReceiver", "Landroid/os/ResultReceiver;", "activityResultCallback", "Landroidx/activity/result/ActivityResultCallback;", "Landroidx/activity/result/ActivityResult;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "sendError", "exception", "Lcom/kakao/sdk/common/model/KakaoSdkError;", "auth_release"})
@SourceDebugExtension(value={"SMAP\nTalkAuthCodeActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TalkAuthCodeActivity.kt\ncom/kakao/sdk/auth/TalkAuthCodeActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1549#2:160\n1620#2,3:161\n1855#2,2:164\n1#3:166\n*S KotlinDebug\n*F\n+ 1 TalkAuthCodeActivity.kt\ncom/kakao/sdk/auth/TalkAuthCodeActivity\n*L\n75#1:160\n75#1:161,3\n75#1:164,2\n*E\n"})
public final class TalkAuthCodeActivity
extends AppCompatActivity {
    private ResultReceiver resultReceiver;
    @NotNull
    private final ActivityResultLauncher<Intent> activityResultLauncher;
    @NotNull
    private final String EXTRA_ERROR_TYPE;
    @NotNull
    private final String EXTRA_ERROR_DESCRIPTION;
    @NotNull
    private final String NOT_SUPPORT_ERROR;
    @NotNull
    private final String UNKNOWN_ERROR;
    @NotNull
    private final String PROTOCOL_ERROR;
    @NotNull
    private final String APPLICATION_ERROR;
    @NotNull
    private final String AUTH_CODE_ERROR;
    @NotNull
    private final String CLIENT_INFO_ERROR;

    public TalkAuthCodeActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), this.activityResultCallback());
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026ityResultCallback()\n    )");
        this.activityResultLauncher = activityResultLauncher;
        this.EXTRA_ERROR_TYPE = "com.kakao.sdk.talk.error.type";
        this.EXTRA_ERROR_DESCRIPTION = "com.kakao.sdk.talk.error.description";
        this.NOT_SUPPORT_ERROR = "NotSupportError";
        this.UNKNOWN_ERROR = "UnknownError";
        this.PROTOCOL_ERROR = "ProtocolError";
        this.APPLICATION_ERROR = "ApplicationError";
        this.AUTH_CODE_ERROR = "AuthCodeError";
        this.CLIENT_INFO_ERROR = "ClientInfoError";
    }

    /*
     * WARNING - void declaration
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_talk_auth_code);
        try {
            Bundle bundle = this.getIntent().getExtras();
            if (bundle == null) {
                throw new IllegalArgumentException("no extras.");
            }
            Bundle extras = bundle;
            Bundle bundle2 = extras.getBundle("key.bundle");
            if (bundle2 != null) {
                ResultReceiver resultReceiver2;
                ResultReceiver resultReceiver3;
                Bundle $this$onCreate_u24lambda_u240 = bundle2;
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    resultReceiver3 = (ResultReceiver)$this$onCreate_u24lambda_u240.getParcelable("key.result.receiver", ResultReceiver.class);
                } else {
                    Parcelable parcelable = $this$onCreate_u24lambda_u240.getParcelable("key.result.receiver");
                    Intrinsics.checkNotNull((Object)parcelable, (String)"null cannot be cast to non-null type android.os.ResultReceiver");
                    resultReceiver3 = resultReceiver2 = (ResultReceiver)parcelable;
                }
                if (resultReceiver2 == null) {
                    throw new IllegalStateException();
                }
                this.resultReceiver = resultReceiver2;
            }
            int requestCode = extras.getInt("key.request.code");
            SdkLog.Companion.i((Object)("requestCode: " + requestCode));
            Intent loginIntent = Build.VERSION.SDK_INT >= 33 ? (Intent)extras.getParcelable("key.login.intent", Intent.class) : (Intent)extras.getParcelable("key.login.intent");
            SdkLog.Companion.i((Object)"loginIntent:");
            Intent intent = loginIntent;
            if (intent != null && (intent = intent.getExtras()) != null) {
                Intent $this$onCreate_u24lambda_u244 = intent;
                boolean bl = false;
                SdkLog.Companion.i((Object)("\tcom.kakao.sdk.talk.appKey : " + $this$onCreate_u24lambda_u244.getString("com.kakao.sdk.talk.appKey")));
                SdkLog.Companion.i((Object)("\tcom.kakao.sdk.talk.redirectUri : " + $this$onCreate_u24lambda_u244.getString("com.kakao.sdk.talk.redirectUri")));
                SdkLog.Companion.i((Object)("\tcom.kakao.sdk.talk.kaHeader : " + $this$onCreate_u24lambda_u244.getString("com.kakao.sdk.talk.kaHeader")));
                Bundle bundle3 = $this$onCreate_u24lambda_u244.getBundle("com.kakao.sdk.talk.extraparams");
                if (bundle3 != null) {
                    void $this$forEach$iv;
                    void $this$mapTo$iv$iv;
                    Bundle $this$onCreate_u24lambda_u244_u24lambda_u243 = bundle3;
                    boolean bl2 = false;
                    SdkLog.Companion.i((Object)"\tcom.kakao.sdk.talk.extraparams");
                    Set set = $this$onCreate_u24lambda_u244_u24lambda_u243.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet()");
                    Iterable $this$map$iv = set;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add("\t\t" + (String)it + " : " + $this$onCreate_u24lambda_u244_u24lambda_u243.getString((String)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        SdkLog.Companion.i((Object)it);
                    }
                }
            }
            this.activityResultLauncher.launch((Object)loginIntent);
        }
        catch (Throwable e) {
            void $this$onCreate_u24lambda_u245;
            ClientError clientError;
            SdkLog.Companion.e((Object)e);
            ClientError loginIntent = clientError = new ClientError(ClientErrorCause.Unknown, null, 2, null);
            TalkAuthCodeActivity talkAuthCodeActivity = this;
            boolean bl = false;
            $this$onCreate_u24lambda_u245.initCause(e);
            talkAuthCodeActivity.sendError((KakaoSdkError)clientError);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendError(KakaoSdkError exception) {
        if (this.resultReceiver != null) {
            void $this$sendError_u24lambda_u246;
            Bundle bundle;
            ResultReceiver resultReceiver2 = this.resultReceiver;
            if (resultReceiver2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultReceiver");
                resultReceiver2 = null;
            }
            Bundle bundle2 = bundle = new Bundle();
            int n = 0;
            ResultReceiver resultReceiver3 = resultReceiver2;
            boolean bl = false;
            $this$sendError_u24lambda_u246.putSerializable("key.exception", (Serializable)exception);
            Unit unit = Unit.INSTANCE;
            resultReceiver3.send(n, bundle);
        }
        this.finish();
    }

    private final ActivityResultCallback<ActivityResult> activityResultCallback() {
        return arg_0 -> TalkAuthCodeActivity.activityResultCallback$lambda$7(this, arg_0);
    }

    @NotNull
    public final String getEXTRA_ERROR_TYPE() {
        return this.EXTRA_ERROR_TYPE;
    }

    @NotNull
    public final String getEXTRA_ERROR_DESCRIPTION() {
        return this.EXTRA_ERROR_DESCRIPTION;
    }

    @NotNull
    public final String getNOT_SUPPORT_ERROR() {
        return this.NOT_SUPPORT_ERROR;
    }

    @NotNull
    public final String getUNKNOWN_ERROR() {
        return this.UNKNOWN_ERROR;
    }

    @NotNull
    public final String getPROTOCOL_ERROR() {
        return this.PROTOCOL_ERROR;
    }

    @NotNull
    public final String getAPPLICATION_ERROR() {
        return this.APPLICATION_ERROR;
    }

    @NotNull
    public final String getAUTH_CODE_ERROR() {
        return this.AUTH_CODE_ERROR;
    }

    @NotNull
    public final String getCLIENT_INFO_ERROR() {
        return this.CLIENT_INFO_ERROR;
    }

    private static final void activityResultCallback$lambda$7(TalkAuthCodeActivity this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Bundle bundle = new Bundle();
        if (result.getData() == null || result.getResultCode() == 0) {
            this$0.sendError((KakaoSdkError)new ClientError(ClientErrorCause.Cancelled, null, 2, null));
            return;
        }
        if (result.getResultCode() == -1) {
            Bundle extras;
            Intent intent = result.getData();
            Object object = extras = intent != null ? intent.getExtras() : null;
            if (extras == null) {
                this$0.sendError((KakaoSdkError)new ClientError(ClientErrorCause.Unknown, "No result from KakaoTalk."));
                return;
            }
            String error = extras.getString(this$0.EXTRA_ERROR_TYPE);
            String errorDescription = extras.getString(this$0.EXTRA_ERROR_DESCRIPTION);
            if (Intrinsics.areEqual((Object)error, (Object)"access_denied")) {
                this$0.sendError((KakaoSdkError)new ClientError(ClientErrorCause.Cancelled, null, 2, null));
                return;
            }
            if (error != null) {
                String string;
                AuthErrorCause cause;
                AuthErrorCause authErrorCause = (AuthErrorCause)KakaoJson.INSTANCE.fromJson(error, (Type)((Object)AuthErrorCause.class));
                if (authErrorCause == null) {
                    authErrorCause = cause = AuthErrorCause.Unknown;
                }
                if ((string = errorDescription) == null) {
                    string = "no error description";
                }
                this$0.sendError((KakaoSdkError)new AuthError(302, cause, new AuthErrorResponse(error, string)));
                return;
            }
            bundle.putParcelable("key.url", (Parcelable)Uri.parse((String)extras.getString("com.kakao.sdk.talk.redirectUrl")));
            ResultReceiver resultReceiver2 = this$0.resultReceiver;
            if (resultReceiver2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultReceiver");
                resultReceiver2 = null;
            }
            resultReceiver2.send(-1, bundle);
            this$0.finish();
            this$0.overridePendingTransition(0, 0);
            return;
        }
        throw new IllegalArgumentException();
    }
}

