/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.auth;

import com.google.gson.JsonObject;
import com.kakao.sdk.auth.TokenManageable;
import com.kakao.sdk.auth.TokenManager;
import com.kakao.sdk.auth.model.OAuthToken;
import com.kakao.sdk.common.KakaoSdk;
import com.kakao.sdk.common.util.AESCipher;
import com.kakao.sdk.common.util.Cipher;
import com.kakao.sdk.common.util.KakaoJson;
import com.kakao.sdk.common.util.PersistentKVStore;
import com.kakao.sdk.common.util.SdkLog;
import com.kakao.sdk.common.util.SharedPrefsWrapper;
import java.lang.reflect.Type;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/kakao/sdk/auth/TokenManager;", "Lcom/kakao/sdk/auth/TokenManageable;", "appCache", "Lcom/kakao/sdk/common/util/PersistentKVStore;", "encryptor", "Lcom/kakao/sdk/common/util/Cipher;", "(Lcom/kakao/sdk/common/util/PersistentKVStore;Lcom/kakao/sdk/common/util/Cipher;)V", "getAppCache", "()Lcom/kakao/sdk/common/util/PersistentKVStore;", "currentToken", "Lcom/kakao/sdk/auth/model/OAuthToken;", "getEncryptor", "()Lcom/kakao/sdk/common/util/Cipher;", "clear", "", "getToken", "migrateFromOldVersion", "setToken", "token", "Companion", "auth_release"})
@SourceDebugExtension(value={"SMAP\nTokenManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenManager.kt\ncom/kakao/sdk/auth/TokenManager\n+ 2 TokenManager.kt\ncom/kakao/sdk/auth/TokenManagerKt\n*L\n1#1,193:1\n187#2,6:194\n187#2,6:200\n187#2,6:206\n187#2,6:212\n*S KotlinDebug\n*F\n+ 1 TokenManager.kt\ncom/kakao/sdk/auth/TokenManager\n*L\n134#1:194,6\n145#1:200,6\n156#1:206,6\n161#1:212,6\n*E\n"})
public final class TokenManager
implements TokenManageable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentKVStore appCache;
    @NotNull
    private final Cipher encryptor;
    @Nullable
    private OAuthToken currentToken;
    @NotNull
    private static final Lazy<TokenManager> instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);
    @NotNull
    public static final String atKey = "com.kakao.token.AccessToken";
    @NotNull
    public static final String rtKey = "com.kakao.token.RefreshToken";
    @NotNull
    public static final String atExpiresAtKey = "com.kakao.token.OAuthToken.ExpiresAt";
    @NotNull
    public static final String rtExpiresAtKey = "com.kakao.token.RefreshToken.ExpiresAt";
    @NotNull
    public static final String secureModeKey = "com.kakao.token.KakaoSecureMode";
    @NotNull
    public static final String tokenKey = "com.kakao.sdk.oauth_token";
    @NotNull
    public static final String versionKey = "com.kakao.sdk.version";

    /*
     * WARNING - void declaration
     */
    public TokenManager(@NotNull PersistentKVStore appCache, @NotNull Cipher encryptor) {
        OAuthToken oAuthToken;
        Intrinsics.checkNotNullParameter((Object)appCache, (String)"appCache");
        Intrinsics.checkNotNullParameter((Object)encryptor, (String)"encryptor");
        this.appCache = appCache;
        this.encryptor = encryptor;
        String version = PersistentKVStore.DefaultImpls.getString$default((PersistentKVStore)this.appCache, (String)versionKey, null, (int)2, null);
        if (version == null) {
            this.migrateFromOldVersion();
        }
        TokenManager tokenManager = this;
        String string = PersistentKVStore.DefaultImpls.getString$default((PersistentKVStore)this.appCache, (String)tokenKey, null, (int)2, null);
        if (string != null) {
            OAuthToken oAuthToken2;
            String string2 = string;
            TokenManager tokenManager2 = tokenManager;
            boolean bl = false;
            try {
                void it;
                oAuthToken2 = (OAuthToken)KakaoJson.INSTANCE.fromJson(this.encryptor.decrypt((String)it), (Type)((Object)OAuthToken.class));
            }
            catch (Throwable e) {
                SdkLog.Companion.e((Object)e);
                oAuthToken2 = null;
            }
            oAuthToken = oAuthToken2;
            tokenManager = tokenManager2;
        } else {
            oAuthToken = null;
        }
        tokenManager.currentToken = oAuthToken;
    }

    public /* synthetic */ TokenManager(PersistentKVStore persistentKVStore, Cipher cipher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            persistentKVStore = (PersistentKVStore)new SharedPrefsWrapper(KakaoSdk.INSTANCE.getApplicationContextInfo().getSharedPreferences());
        }
        if ((n & 2) != 0) {
            cipher = (Cipher)new AESCipher(null, 1, null);
        }
        this(persistentKVStore, cipher);
    }

    @NotNull
    public final PersistentKVStore getAppCache() {
        return this.appCache;
    }

    @NotNull
    public final Cipher getEncryptor() {
        return this.encryptor;
    }

    @Override
    @Nullable
    public OAuthToken getToken() {
        return this.currentToken;
    }

    @Override
    public synchronized void setToken(@NotNull OAuthToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        OAuthToken newToken = OAuthToken.copy$default(token, null, null, null, null, null, null, 63, null);
        try {
            this.appCache.putString(tokenKey, this.encryptor.encrypt(KakaoJson.INSTANCE.toJson((Object)newToken))).commit();
        }
        catch (Throwable e) {
            SdkLog.Companion.e((Object)e);
        }
        this.currentToken = newToken;
    }

    @Override
    public void clear() {
        this.currentToken = null;
        this.appCache.remove(tokenKey).commit();
    }

    private final void migrateFromOldVersion() {
        long rtExpiresAt;
        Long l;
        Long l2;
        String e$iv2;
        String string;
        String string2;
        String it;
        SdkLog.Companion.i((Object)"=== Migrate from old version token");
        this.appCache.putString(versionKey, "2.21.0.1-SNAPSHOT").commit();
        String string3 = this.appCache.getString(secureModeKey, null);
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            string2 = ((JsonObject)KakaoJson.INSTANCE.fromJson(it, (Type)((Object)JsonObject.class))).get("value").getAsString();
        } else {
            string2 = null;
        }
        String string4 = string2;
        String secureMode = string4 == null ? "false" : string4;
        SdkLog.Companion.i((Object)("secureMode: " + secureMode));
        boolean $i$f$parseOrNull = false;
        try {
            String string5;
            boolean bl = false;
            String string6 = this.appCache.getString(atKey, null);
            if (string6 != null) {
                it = string6;
                boolean bl2 = false;
                String legacyAt = ((JsonObject)KakaoJson.INSTANCE.fromJson(it, (Type)((Object)JsonObject.class))).get("value").getAsString();
                string5 = legacyAt != null && Intrinsics.areEqual((Object)secureMode, (Object)"true") ? this.encryptor.decrypt(legacyAt) : legacyAt;
            } else {
                string5 = null;
            }
            string = string5;
        }
        catch (Exception e$iv2) {
            SdkLog.Companion.e((Object)e$iv2);
            string = null;
        }
        String at = string;
        SdkLog.Companion.i((Object)("accessToken: " + at));
        boolean $i$f$parseOrNull2 = false;
        try {
            String string7;
            boolean bl = false;
            String string8 = this.appCache.getString(rtKey, null);
            if (string8 != null) {
                String it2 = string8;
                boolean bl3 = false;
                String legacyRt = ((JsonObject)KakaoJson.INSTANCE.fromJson(it2, (Type)((Object)JsonObject.class))).get("value").getAsString();
                string7 = legacyRt != null && Intrinsics.areEqual((Object)secureMode, (Object)"true") ? this.encryptor.decrypt(legacyRt) : legacyRt;
            } else {
                string7 = null;
            }
            e$iv2 = string7;
        }
        catch (Exception e$iv3) {
            SdkLog.Companion.e((Object)e$iv3);
            e$iv2 = null;
        }
        String rt = e$iv2;
        SdkLog.Companion.i((Object)("refreshToken: " + rt));
        boolean $i$f$parseOrNull3 = false;
        try {
            Long l3;
            boolean bl = false;
            String string9 = this.appCache.getString(atExpiresAtKey, null);
            if (string9 != null) {
                String it3 = string9;
                boolean bl4 = false;
                l3 = ((JsonObject)KakaoJson.INSTANCE.fromJson(it3, (Type)((Object)JsonObject.class))).get("value").getAsLong();
            } else {
                l3 = null;
            }
            l2 = l3;
        }
        catch (Exception e$iv4) {
            SdkLog.Companion.e((Object)e$iv4);
            l2 = null;
        }
        Long l4 = l2;
        long atExpiresAt = l4 != null ? l4 : 0L;
        boolean $i$f$parseOrNull4 = false;
        try {
            Long l5;
            boolean bl = false;
            String string10 = this.appCache.getString(rtExpiresAtKey, null);
            if (string10 != null) {
                String it4 = string10;
                boolean bl5 = false;
                l5 = ((JsonObject)KakaoJson.INSTANCE.fromJson(it4, (Type)((Object)JsonObject.class))).get("value").getAsLong();
            } else {
                l5 = null;
            }
            l = l5;
        }
        catch (Exception e$iv5) {
            SdkLog.Companion.e((Object)e$iv5);
            l = null;
        }
        Long l6 = l;
        long l7 = rtExpiresAt = l6 != null ? l6 : Long.MAX_VALUE;
        if (at != null && rt != null) {
            OAuthToken token = new OAuthToken(at, new Date(atExpiresAt), rt, new Date(rtExpiresAt), null, null, 48, null);
            this.appCache.putString(tokenKey, this.encryptor.encrypt(KakaoJson.INSTANCE.toJson((Object)token))).remove(secureModeKey).remove(atKey).remove(rtKey).remove(atExpiresAtKey).remove(rtExpiresAtKey).commit();
        }
    }

    public TokenManager() {
        this(null, null, 3, null);
    }

    @NotNull
    public static final TokenManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u00020\u00078FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/kakao/sdk/auth/TokenManager$Companion;", "", "()V", "atExpiresAtKey", "", "atKey", "instance", "Lcom/kakao/sdk/auth/TokenManager;", "getInstance$annotations", "getInstance", "()Lcom/kakao/sdk/auth/TokenManager;", "instance$delegate", "Lkotlin/Lazy;", "rtExpiresAtKey", "rtKey", "secureModeKey", "tokenKey", "versionKey", "auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenManager getInstance() {
            Lazy lazy = instance$delegate;
            return (TokenManager)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

