/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.sdk.auth.network;

import com.kakao.sdk.auth.AuthApiManager;
import com.kakao.sdk.auth.TokenManagerProvider;
import com.kakao.sdk.auth.model.OAuthToken;
import com.kakao.sdk.auth.network.AccessTokenInterceptorKt;
import com.kakao.sdk.common.model.ApiError;
import com.kakao.sdk.common.model.ApiErrorCause;
import com.kakao.sdk.common.model.ApiErrorResponse;
import com.kakao.sdk.common.model.ClientError;
import com.kakao.sdk.common.model.ClientErrorCause;
import com.kakao.sdk.common.util.KakaoJson;
import com.kakao.sdk.network.ExceptionWrapper;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/kakao/sdk/auth/network/AccessTokenInterceptor;", "Lokhttp3/Interceptor;", "tokenManagerProvider", "Lcom/kakao/sdk/auth/TokenManagerProvider;", "manager", "Lcom/kakao/sdk/auth/AuthApiManager;", "(Lcom/kakao/sdk/auth/TokenManagerProvider;Lcom/kakao/sdk/auth/AuthApiManager;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "auth_release"})
@SourceDebugExtension(value={"SMAP\nAccessTokenInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessTokenInterceptor.kt\ncom/kakao/sdk/auth/network/AccessTokenInterceptor\n+ 2 Utility.kt\ncom/kakao/sdk/network/UtilityKt\n*L\n1#1,92:1\n53#2:93\n35#2,32:94\n*S KotlinDebug\n*F\n+ 1 AccessTokenInterceptor.kt\ncom/kakao/sdk/auth/network/AccessTokenInterceptor\n*L\n47#1:93\n47#1:94,32\n*E\n"})
public final class AccessTokenInterceptor
implements Interceptor {
    @NotNull
    private final TokenManagerProvider tokenManagerProvider;
    @NotNull
    private final AuthApiManager manager;

    public AccessTokenInterceptor(@NotNull TokenManagerProvider tokenManagerProvider, @NotNull AuthApiManager manager) {
        Intrinsics.checkNotNullParameter((Object)tokenManagerProvider, (String)"tokenManagerProvider");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.tokenManagerProvider = tokenManagerProvider;
        this.manager = manager;
    }

    public /* synthetic */ AccessTokenInterceptor(TokenManagerProvider tokenManagerProvider, AuthApiManager authApiManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tokenManagerProvider = TokenManagerProvider.Companion.getInstance();
        }
        if ((n & 2) != 0) {
            authApiManager = AuthApiManager.Companion.getInstance();
        }
        this(tokenManagerProvider, authApiManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        ResponseBody body$iv$iv;
        String string;
        String usedAccessToken;
        block22: {
            block21: {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                OAuthToken oAuthToken = this.tokenManagerProvider.getManager().getToken();
                usedAccessToken = oAuthToken != null ? oAuthToken.getAccessToken() : null;
                string = usedAccessToken;
                if (string == null) break block21;
                String it = string;
                boolean bl = false;
                Request request = AccessTokenInterceptorKt.withAccessToken(chain.request(), it);
                string = request;
                if (request != null) break block22;
            }
            throw new ExceptionWrapper((Throwable)new ClientError(ClientErrorCause.TokenNotFound, null, 2, null));
        }
        String request = string;
        Interceptor.Chain $this$proceedApiError$iv = chain;
        boolean $i$f$proceedApiError = false;
        Interceptor.Chain $this$proceedBodyString$iv$iv = $this$proceedApiError$iv;
        boolean $i$f$proceedBodyString = false;
        Response originalResponse$iv$iv = $this$proceedBodyString$iv$iv.proceed((Request)request);
        ResponseBody responseBody = body$iv$iv = originalResponse$iv$iv.body();
        String bodyString$iv$iv = responseBody != null ? responseBody.string() : null;
        String string2 = bodyString$iv$iv;
        Response newResponse$iv$iv = originalResponse$iv$iv.newBuilder().body(string2 != null ? ResponseBody.Companion.create(string2, body$iv$iv.contentType()) : null).build();
        String string3 = bodyString$iv$iv;
        if (string3 != null) {
            ResponseBody.Companion.create(string3, body$iv$iv.contentType());
        }
        String string4 = bodyString$iv$iv;
        Response response$iv = newResponse$iv$iv;
        boolean bl = false;
        if (!response$iv.isSuccessful()) {
            ApiErrorCause apiErrorCause$iv;
            ApiErrorCause apiErrorCause;
            ApiErrorResponse apiErrorResponse$iv;
            ApiErrorResponse apiErrorResponse;
            void bodyString$iv;
            void v6 = bodyString$iv;
            if (v6 != null) {
                void it$iv = v6;
                boolean bl2 = false;
                apiErrorResponse = (ApiErrorResponse)KakaoJson.INSTANCE.fromJson((String)it$iv, (Type)((Object)ApiErrorResponse.class));
            } else {
                apiErrorResponse = null;
            }
            ApiErrorResponse apiErrorResponse2 = apiErrorResponse$iv = apiErrorResponse;
            if (apiErrorResponse2 != null) {
                ApiErrorResponse it$iv = apiErrorResponse2;
                boolean bl3 = false;
                apiErrorCause = (ApiErrorCause)KakaoJson.INSTANCE.fromJson(String.valueOf(it$iv.getCode()), (Type)((Object)ApiErrorCause.class));
            } else {
                apiErrorCause = apiErrorCause$iv = null;
            }
            if (apiErrorCause$iv != null) {
                void error;
                ApiError apiError = new ApiError(response$iv.code(), apiErrorCause$iv, apiErrorResponse$iv);
                Response response = response$iv;
                boolean bl4 = false;
                if (error.getReason() != ApiErrorCause.InvalidToken) {
                    return response;
                }
                AccessTokenInterceptor accessTokenInterceptor2 = this;
                synchronized (accessTokenInterceptor2) {
                    block20: {
                        String string5;
                        boolean bl5 = false;
                        OAuthToken oAuthToken = this.tokenManagerProvider.getManager().getToken();
                        if (oAuthToken == null) break block20;
                        OAuthToken currentToken = oAuthToken;
                        if (!Intrinsics.areEqual((Object)currentToken.getAccessToken(), (Object)usedAccessToken)) {
                            string5 = currentToken.getAccessToken();
                        } else {
                            String string6;
                            try {
                                string6 = this.manager.refreshToken$auth_release(currentToken).getAccessToken();
                            }
                            catch (Throwable e) {
                                throw new ExceptionWrapper(e);
                            }
                            string5 = string6;
                        }
                        String accessToken = string5;
                        String requestUrl = request.url().toString();
                        if (StringsKt.contains$default((CharSequence)requestUrl, (CharSequence)"/v1/user/check_access_token", (boolean)false, (int)2, null)) break block20;
                        Response response2 = chain.proceed(AccessTokenInterceptorKt.withAccessToken((Request)request, accessToken));
                        return response2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                return response;
            }
        }
        return response$iv;
    }

    public AccessTokenInterceptor() {
        this(null, null, 3, null);
    }
}

