/*
  Copyright 2019 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.auth

import com.kakao.sdk.auth.model.OAuthToken

/**
 * 토큰 저장소 인터페이스<br>Interface for the token manager
 */
interface TokenManageable {
    /**
     * 저장된 토큰 반환<br>Returns saved tokens
     */
    fun getToken(): OAuthToken?

    /**
     * 토큰 저장<br>Saves tokens
     *
     * @param token 토큰 정보<br>Token information
     */
    fun setToken(token: OAuthToken)

    /**
     * 저장된 토큰 삭제<br>Deletes saved tokens
     */
    fun clear()
}
