/*
  Copyright 2020 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.auth

/**
 * 토큰 저장소 설정<br>Setting for the token manager
 *
 * @property manager 토큰 저장소 직접 지정, `TokenManageable`을 구현한 사용자 정의 토큰 매니저 설정 가능<br>Set the custom token manager that implements `TokenManageable`
 */
class TokenManagerProvider(
    var manager: TokenManageable = TokenManager.instance
) {

    companion object {

        /**
         * 간편한 API 요청을 위해 제공되는 싱글톤 객체<br>A singleton object to call APIs easier
         */
        @JvmStatic
        val instance by lazy { TokenManagerProvider() }
    }
}
