/*
  Copyright 2021 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.auth.model

import android.os.Parcelable
import com.kakao.sdk.auth.TokenManagerProvider
import kotlinx.parcelize.Parcelize

/**
 *
 * 토큰 정보와 전자서명 접수번호<br>Token information and transaction ID
 *
 * @property token 토큰 정보<br>Token information
 * @property txId 전자서명 접수번호<br>Transaction ID
 */
@Parcelize
data class CertTokenInfo (
    val token: OAuthToken,
    val txId: String
) : Parcelable