/*
  Copyright 2020 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.auth.model

import com.google.gson.annotations.SerializedName

/**
 * 동의 화면에 상호작용 추가 요청 프롬프트<br>Prompt to add an interaction to the consent screen
 */
enum class Prompt {
    /**
     * 사용자 재인증<br>Reauthenticate user
     */
    @SerializedName("login")
    LOGIN,

    /**
     * 카카오계정 가입 후 로그인<br>Login after signing up for a Kakao Account 
     */
    @SerializedName("create")
    CREATE,

    /**
     * 카카오계정 간편로그인<br>Kakao Account easy login
     */
    @SerializedName("select_account")
    SELECT_ACCOUNT,

    /**
     * @suppress
     * 인증 로그인<br>Certification Login
     */
    @SerializedName("cert")
    CERT,

    /**
     * @suppress
     * Internal Only
     */
    @SerializedName("unify_daum")
    UNIFY_DAUM;

    val value: String
        get() = this.javaClass.getField(this.name).getAnnotation(SerializedName::class.java)!!.value
}
