/*
  Copyright 2023 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.user

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import java.util.concurrent.TimeUnit

/**
 * @suppress
 */
class AppLifecycleObserver : LifecycleEventObserver {
    private var prevTimeMillis = 0L

    override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
        if (event != Lifecycle.Event.ON_START) return

        val currentTimeMillis = System.currentTimeMillis()

        if (TimeUnit.MILLISECONDS.toHours(currentTimeMillis - prevTimeMillis) < INTERVAL_HOUR) return

        prevTimeMillis = currentTimeMillis

        UserApiClient.instance.checkAccessToken { _, _ -> }
    }

    companion object {
        private const val INTERVAL_HOUR = 6

        @JvmStatic
        val instance by lazy {
            AppLifecycleObserver()
        }
    }
}
