/*
  Copyright 2019 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.user

/**
 * @suppress
 */
object Constants {
    const val V2_ME_PATH = "/v2/user/me"
    const val V2_SCOPES = "/v2/user/scopes"
    const val V2_REVOKE_SCOPE = "/v2/user/revoke/scopes"
    const val V1_ACCESS_TOKEN_INFO_PATH = "/v1/user/access_token_info"
    const val V1_UPDATE_PROFILE_PATH = "/v1/user/update_profile"
    const val V1_AGE_AUTH_INFO_PATH = "/v1/user/age_auth"
    const val V1_LOGOUT_PATH = "/v1/user/logout"
    const val V1_UNLINK_PATH = "/v1/user/unlink"
    const val V1_SHIPPING_ADDRESSES_PATH = "/v1/user/shipping_address"
    const val V2_SERVICE_TERMS_PATH = "/v2/user/service_terms"
    const val V2_REVOKE_SERVICE_TERMS_PATH = "/v2/user/revoke/service_terms"
    const val V1_SIGNUP_PATH = "/v1/user/signup"
    const val KPIDT_PATH = "/auth/kpidt"
    const val SELECT_SHIPPING_ADDRESS_PATH = "/user/address"
    const val APPS_SHIPPING_ADDRESS_SCHEME = "address"

    const val SECURE_RESOURCE = "secure_resource"
    const val EXTRA = "extra"
    const val PROPERTIES = "properties"
    const val PROPERTY_KEYS = "property_keys"
    const val AGE_LIMIT = "age_limit"

    const val ID = "id"
    const val GROUP_USER_TOKEN = "group_user_token"
    const val CONNECTED_AT = "connected_at"
    const val SYNCHED_AT = "synched_at"
    const val HAS_SIGNED_UP = "has_signed_up"
    const val KAKAO_ACCOUNT = "kakao_account"
    const val FOR_PARTNER = "for_partner"


    const val PROFILE_NEEDS_AGREEMENT = "profile_needs_agreement"
    const val PROFILE_NICKNAME_NEEDS_AGREEMENT = "profile_nickname_needs_agreement"
    const val PROFILE_IMAGE_NEEDS_AGREEMENT = "profile_image_needs_agreement"
    const val PROFILE = "profile"

    const val NAME_NEEDS_AGREEMENT = "name_needs_agreement"
    const val NAME = "name"

    const val EMAIL_NEEDS_AGREEMENT = "email_needs_agreement"
    const val IS_EMAIL_VALID = "is_email_valid"
    const val IS_EMAIL_VERIFIED = "is_email_verified"
    const val EMAIL = "email"

    const val AGE_RANGE_NEEDS_AGREEMENT = "age_range_needs_agreement"
    const val AGE_RANGE = "age_range"

    const val BIRTHYEAR_NEEDS_AGREEMENT = "birthyear_needs_agreement"
    const val BIRTHYEAR = "birthyear"

    const val BIRTHDAY_NEEDS_AGREEMENT = "birthday_needs_agreement"
    const val BIRTHDAY = "birthday"
    const val BIRTHDAY_TYPE = "birthday_type"

    const val GENDER_NEEDS_AGREEMENT = "gender_needs_agreement"
    const val GENDER = "gender"

    const val LEGAL_NAME_NEEDS_AGREEMENT = "legal_name_needs_agreement"
    const val LEGAL_NAME = "legal_name"

    const val LEGAL_BIRTH_DATE_NEEDS_AGREEMENT = "legal_birth_date_needs_agreement"
    const val LEGAL_BIRTH_DATE = "legal_birth_date"

    const val LEGAL_GENDER_NEEDS_AGREEMENT = "legal_gender_needs_agreement"
    const val LEGAL_GENDER = "legal_gender"

    const val PHONE_NUMBER_NEEDS_AGREEMENT = "phone_number_needs_agreement"
    const val PHONE_NUMBER = "phone_number"

    const val IS_KOREAN_NEEDS_AGREEMENT = "is_korean_needs_agreement"
    const val IS_KOREAN = "is_korean"

    const val IS_KAKAOTALK_USER = "is_kakaotalk_user"
    const val HAS_PHONE_NUMBER = "has_phone_number"

    const val DISPLAY_ID = "display_id"
    const val DISPLAY_NAME = "display_name"
    const val TYPE = "type"
    const val USING = "using"
    const val DELEGATED = "delegated"
    const val AGREED = "agreed"
    const val REVOCABLE = "revocable"

    const val TAGS = "tags"
    const val RESULT = "result"
    const val USER_ID = "user_id"
    const val SERVICE_TERMS = "service_terms"
    const val REVOKED_SERVICE_TERMS = "revoked_service_terms"
    const val TAG = "tag"
    const val AGREED_AT = "agreed_at"
    const val AGREED_BY = "agreed_by"
    const val REQUIRED = "required"
    const val UPDATED_AT = "updated_at"

    const val SHIPPING_ADDRESSES_NEEDS_AGREEMENT = "shipping_addresses_needs_agreement"
    const val SHIPPING_ADDRESSES = "shipping_addresses"
    const val IS_DEFAULT = "is_default"
    const val BASE_ADDRESS = "base_address"
    const val DETAIL_ADDRESS = "detail_address"
    const val RECEIVER_NAME = "receiver_name"
    const val RECEIVER_PHONE_NUMBER1 = "receiver_phone_number1"
    const val RECEIVER_PHONE_NUMBER2 = "receiver_phone_number2"
    const val ZONE_NUMBER = "zone_number"
    const val ZIP_CODE = "zip_code"

    const val APP_ID = "app_id"
    const val EXPIRESINMILLIS = "expiresInMillis"
    const val KACCOUNT_ID = "kaccount_id"
    const val EXPIRES_IN = "expires_in"

    const val ADDRESS_ID = "address_id"
    const val FROM_UPDATED_AT = "from_updated_at"
    const val PAGE_SIZE = "page_size"

    const val NICKNAME = "nickname"
    const val PROFILE_IMAGE_URL = "profile_image_url"
    const val THUMBNAIL_IMAGE_URL = "thumbnail_image_url"
    const val IS_DEFAULT_IMAGE = "is_default_image"

    const val SCOPES = "scopes"

    const val ENABLE_BACK_BUTTON = "enable_back_button"
    const val KA = "ka"
    const val CONTINUE = "continue"
    const val RETURN_URL = "return_url"
    const val APPS_RESULT_STATUS = "status"
    const val APPS_RESULT_ERROR = "error"
}
