/*
  Copyright 2023 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.user.model

/**
 * 서비스 약관 동의 철회하기 응답<br>Response for Revoke consent for service terms
 *
 * @property id 회원번호<br>Service user ID
 * @property revokedServiceTerms 동의 철회에 성공한 서비스 약관 목록<br>List of revoked service terms
 */
data class UserRevokedServiceTerms(
    val id: Long,
    val revokedServiceTerms: List<RevokedServiceTerms>?,
)

/**
 * 동의 철회된 서비스 약관 정보<br>Revoked service terms information
 *
 * @property tag 태그<br>Tag
 * @property agreed 동의 여부<br>The consent status of the service terms
 */
data class RevokedServiceTerms(
    val tag: String,
    val agreed: Boolean,
)
