/*
  Copyright 2019 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.user.model

import com.google.gson.annotations.SerializedName
import com.kakao.sdk.common.json.UnknownValue
import com.kakao.sdk.user.Constants
import java.util.Date

/**
 * 서비스 약관 동의 내역 확인하기 응답<br>Response for Retrieve consent details for service terms
 *
 * @property id 회원번호<br>Service user ID
 * @property serviceTerms 서비스 약관 목록<br>List of service terms
 */
data class UserServiceTerms(
    val id: Long,
    val serviceTerms: List<ServiceTerms>?,
)

/**
 * 서비스 약관 정보<br>Service terms information
 *
 * @property tag 태그<br>Tag
 * @property required 필수 동의 여부<br>Whether consent is required
 * @property agreed 동의 여부<br>The consent status of the service terms
 * @property revocable 철회 가능 여부<br>Whether consent is revocable
 * @property agreedAt 마지막으로 동의한 시간<br>The last time user agreed to the scope
 * @property referer 서비스 약관의 동의 경로<br>Path through which the service terms were agreed to.
 */
data class ServiceTerms(
    val tag: String,
    val required: Boolean,
    val agreed: Boolean,
    val revocable: Boolean,
    val agreedAt: Date?,
    @SerializedName(Constants.AGREED_BY)
    val referer: Referer?,
) {
    /**
     * 서비스 약관의 동의 경로<br>Path through which the service terms were agreed to.
     */
    enum class Referer {
        /**
         * 카카오싱크 간편가입 동의 화면<br>Consent screen of Kakao Sync Simple Signup.
         */
        KAUTH,

        /**
         * 기타<br>Other paths.
         */
        KAPI,

        /**
         * 알 수 없음<br>Unknown
         */
        @UnknownValue
        UNKNOWN
    }
}
