/*
  Copyright 2019 Kakao Corp.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
 */
package com.kakao.sdk.user

import android.net.Uri
import com.kakao.sdk.common.KakaoSdk
import com.kakao.sdk.common.model.ServerHosts

/**
 * @suppress
 */
class UriUtility(private val hosts: ServerHosts = KakaoSdk.hosts) {

    fun kpidtUrl(
        agt: String,
        continueUrl: String,
        appKey: String = KakaoSdk.appKey,
    ): Uri = Uri.Builder()
        .scheme(com.kakao.sdk.common.Constants.SCHEME)
        .authority(hosts.apps)
        .path(Constants.KPIDT_PATH)
        .appendQueryParameter(com.kakao.sdk.common.Constants.APP_KEY, appKey)
        .appendQueryParameter(com.kakao.sdk.auth.Constants.AGT, agt)
        .appendQueryParameter(Constants.CONTINUE, continueUrl)
        .build()

    fun shippingAddressUrl(
        path: String,
        addressId: Long? = null,
        appKey: String = KakaoSdk.appKey,
        ka: String = KakaoSdk.kaHeader,
        returnUrl: String = "${KakaoSdk.applicationContextInfo.customScheme}://${Constants.APPS_SHIPPING_ADDRESS_SCHEME}",
    ): Uri = Uri.Builder()
        .scheme(com.kakao.sdk.common.Constants.SCHEME)
        .authority(hosts.apps)
        .path(path)
        .appendQueryParameter(com.kakao.sdk.common.Constants.APP_KEY, appKey)
        .appendQueryParameter(Constants.KA, ka)
        .appendQueryParameter(Constants.RETURN_URL, returnUrl)
        .appendQueryParameter(Constants.ENABLE_BACK_BUTTON, "false") // 웹 플랫폼 전용 파라미터
        .apply {
            addressId?.let { appendQueryParameter(Constants.ADDRESS_ID, it.toString()) }
        }
        .build()
}
